<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */
$automatic_config = automatic_settings();
get_header();
$bg_404 = $au_404_title = $au_404_txt = '';
if ( $automatic_config != '' ) :
	$bg_404 = $automatic_config['404_bg']['url'];
else :
	$bg_404 = get_template_directory_uri(). '/assets/images/bg-404.jpg';
endif;

if( $automatic_config['404_title'] !=''){
	if(get_option('404_title')){
		$au_404_title = get_option('404_title');
	}else{
		$au_404_title =$automatic_config['404_title'];
	}
}
if( $automatic_config['404_txt'] !=''){
	if(get_option('404_txt')){
		$au_404_txt = get_option('404_txt');
	}else{
		$au_404_txt =$automatic_config['404_txt'];
	}
}
?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<section class="error-404 not-found">
					<div class="bread-crumb">
						<?php echo automatic_breadcrumbs(); ?>
					</div>
					<div class="content-404">
						<img src="<?php echo esc_url( $bg_404 );?>" alt="">
						<div class="midle">
							<div class="center">
								<header class="page-header">
									<h1 class="page-title"><?php echo esc_html( $au_404_title ); ?></h1>
								</header><!-- .page-header -->
								<div class="page-content">
									<p><?php echo wp_kses_post( $au_404_txt ); ?></p>

									<form role="search" method="get" class="woocommerce-product-search search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
										<label>
											<input type="search" autocomplete="off" id="woocommerce-product-search-field" class="search-field" placeholder="<?php esc_html_e('Search product ...','automatic')?>" value="" name="s" title="<?php esc_html_e('Search product','automatic')?>">
										</label>
										<button type="submit" class="search-submit"><span class="screen-reader-text"><?php esc_html_e('Search','automatic')?></span></button>
										<input type="hidden" name="post_type" value="product">
										<input type="hidden" name="product_cat" value="">
										<div class="auto_ajax_search"></div>
									</form>
								</div><!-- .page-content -->
							</div>
						</div>
					</div>
					<div class="bottom-content-404">
						<?php if(is_active_sidebar('404')){
							dynamic_sidebar( '404' );
						} ?>
					</div>
				</section><!-- .error-404 -->
			</div>
		</main><!-- .site-main -->

	</div><!-- .content-area -->
<?php get_footer(); ?>
