<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$woocommerce_customize = G5Plus_Auteur()->options()->get_woocommerce_customize();
$query_args = $settings = null;
if(!isset($woocommerce_customize['Disable']) || !array_key_exists('cat-filter', $woocommerce_customize['Disable'])) {
    if (is_tax('product_cat')) {
        global $wp_query;
        if (isset($wp_query->queried_object)) {
            $settings['current_cat'] = $wp_query->queried_object->term_id;
        }
    }
}

G5Plus_Auteur()->helper()->get_header('shop'); ?>

	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 * @hooked WC_Structured_Data::generate_website_data() - 30
		 */
		do_action( 'woocommerce_before_main_content' );
	?>
	<?php
	/**
	 * woocommerce_archive_description hook.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	do_action( 'woocommerce_archive_description' );
	?>
	<?php G5Plus_Auteur()->woocommerce()->archive_markup($query_args, $settings);?>
	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

<?php G5Plus_Auteur()->helper()->get_footer('shop'); ?>
