<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('G5P_Widget_Author_Alphabet')) {
	class G5P_Widget_Author_Alphabet extends  GSF_Widget
	{
		public function __construct() {
			$this->widget_cssclass    = 'widget-author-alphabet';
			$this->widget_id          = 'gsf-author-alphabet';
			$this->widget_name        = esc_html__( 'G5Plus: Author Alphabet', 'auteur-framework' );

			$this->settings = array(
				'fields' => array(
					array(
						'id'      => 'title',
						'type'    => 'text',
						'default' => '',
						'title'   => esc_html__('Title:', 'auteur-framework')
					),
                    array(
                        'id'      => 'show_empty',
                        'type'    => 'switch',
                        'default' => '',
                        'title'   => esc_html__('Show Empty?', 'auteur-framework')
                    ),
                    array(
                        'id'      => 'show_all',
                        'type'    => 'switch',
                        'default' => 'on',
                        'title'   => esc_html__('Show "All"?', 'auteur-framework')
                    ),
					array(
							'id' => 'filter_type',
						'title' => esc_html__('Filter Type','auteur-framework'),
						'type' => 'select',
						'options' => array(
							'first-name' => esc_html__('First Name','auteur-framework'),
							'last-name' => esc_html__('Last Name','auteur-framework'),
						),
						'default' => 'first-name'
					)
				)
			);

			parent::__construct();
		}

		public function widget($args, $instance) {
			extract( $args, EXTR_SKIP );
			$wrapper_classes = array(
				'widget-author-alphabet-content'
			);
            $title = (!empty($instance['title'])) ? $instance['title'] : '';
            $show_empty = (!empty($instance['show_empty'])) ? $instance['show_empty'] : '';
            $show_all = (!empty($instance['show_all'])) ? $instance['show_all'] : 'on';
            $filter_type = (!empty($instance['filter_type'])) ? $instance['filter_type'] : 'first-name';
            $title = apply_filters('widget_title', $title, $instance, $this->id_base);
            echo wp_kses_post($args['before_widget']);
            if ($title) {
                echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
            }
            $show_empty = ('on' !== $show_empty) ? '1' : '0';
            $authors = get_categories(array('hide_empty' => $show_empty, 'taxonomy' => 'product_author'));
            $wrapper_class = implode(' ', array_filter($wrapper_classes));
            ?>
                <div class="<?php echo esc_attr($wrapper_class) ?>">
                    <?php if(sizeof($authors)):?>
                        <ul class="gf-author-alphabet">
                        <?php
                        if('on' === $show_all) :?>
                            <li class="character-item active"><a class="gsf-link transition03 no-animation" href="*" title="<?php esc_attr_e('All', 'auteur-framework') ?>"><?php esc_html_e('All', 'auteur-framework') ?></a></li>
                        <?php endif;
                        $exist_characters = array();
                        $prefix = G5P()->getMetaPrefix();
                        foreach ($authors as $author):
                            if ($filter_type === 'first-name') {
	                            $first_name = get_term_meta($author->term_id,"{$prefix}product_author_first_name",true);
	                            $character = mb_substr($first_name, 0, 1);
                            } else {
	                            $last_name = get_term_meta($author->term_id,"{$prefix}product_author_last_name",true);
	                            $character = mb_substr($last_name, 0, 1);
                            }

                            if (!in_array($character, $exist_characters)) {
	                            $exist_characters[] = $character;
                            }
	                        sort($exist_characters);
                            ?>

                        <?php endforeach; ?>

	                    <?php foreach ($exist_characters as $character):  ?>
		                    <li class="character-item"><a class="gsf-link transition03 no-animation" href='[data-<?php echo esc_attr($filter_type)?>="<?php echo esc_attr($character); ?>"]' title="<?php echo strtoupper($character) ?>"><?php echo strtoupper($character) ?></a></li>
						<?php endforeach; ?>



                        </ul>
                    <?php endif; ?>
                </div>
            <?php
			echo wp_kses_post($args['after_widget']);
		}
	}
}