<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/**
 * @var $element UBE_Element_Auteur_Products_Authors
 */

$atts = $element->get_settings();
$wrapper_classes = array(
	'gf-product-authors',
	'ube-product-authors',
);
$element->set_render_attribute('wrapper', array(
	'class' => $wrapper_classes
));

$atts['columns_xl'] = absint($atts['columns']['xl']);
$atts['columns_lg'] = $atts['columns']['lg'] == '' ? $atts['columns_xl'] : absint($atts['columns']['lg']);
$atts['columns_md'] = $atts['columns']['md'] == '' ? $atts['columns_lg'] : absint($atts['columns']['md']);
$atts['columns_sm'] = $atts['columns']['sm'] == '' ? $atts['columns_md'] : absint($atts['columns']['sm']);
$atts['columns'] = $atts['columns']['xs'] == '' ? $atts['columns_sm'] : absint($atts['columns']['xs']);
$item_class = array('gsf-product-author-item');
$inner_class = $owl_args = array();
if('on' === $atts['is_slider']) {
	$inner_class[] = 'owl-carousel owl-theme';
	$inner_class[] = 'gsf-slider-container item-gutter-' . $atts['post_columns_gutter'];
	$owl_args = array(
		'items' => $atts['columns_xl'],
		'slideBy' => $atts['columns_xl'],
		'dots' => ($atts['dots'] === 'on') ? true : false,
		'nav' => ($atts['nav'] === 'on') ? true : false,
		'responsive' => array(
			'1200' => array(
				'items' => $atts['columns_xl'],
				'slideBy' => $atts['columns_xl'],
			),
			'992' => array(
				'items' => $atts['columns_lg'],
				'slideBy' => $atts['columns_lg'],
			),
			'768' => array(
				'items' => $atts['columns_md'],
				'slideBy' => $atts['columns_md'],
			),
			'576' => array(
				'items' => $atts['columns_sm'],
				'slideBy' => $atts['columns_sm'],
			),
			'0' => array(
				'items' => $atts['columns'],
				'slideBy' => $atts['columns'],
			)
		),
		'autoHeight' => true,
		'autoplay' => ($atts['autoplay'] === 'on') ? true : false,
		'autoplayTimeout' => intval($atts['autoplay_timeout']),
	);
	if($atts['nav_style'] == 'nav-square-text' || $atts['nav_style'] == 'nav-circle-text') {
		$owl_args['navText'] = array('<i class="fal fa-angle-left"></i> <span>'.esc_html__( 'Prev', 'auteur-framework' ).'</span>', '<span>'.esc_html__( 'Next', 'auteur-framework' ).'</span> <i class="fal fa-angle-right"></i>');
	}

	if($atts['nav'] === 'on') {
		$inner_class = array_merge($inner_class, array($atts['nav_position'], $atts['nav_style'], $atts['nav_size'], $atts['nav_hover_scheme'], $atts['nav_hover_style']));
	}


} else{
	$inner_class[] = 'gf-gutter-' . $atts['post_columns_gutter'];
	$inner_class[] = 'gf-blog-inner';
	$item_class[] = 'grid-item';
	$columns = array(
		'xl' => $atts['columns_xl'] ,
		'lg' => $atts['columns_lg'],
		'md' => $atts['columns_md'],
		'sm' => $atts['columns'],
		'' => $atts['columns'],
	);
	$item_class[] = G5Plus_Auteur()->helper()->get_bootstrap_columns($columns);
}

$args = array(
	'hide_empty' => '1',
	'taxonomy' => 'product_author'
);
$category = array();
$product_authors = array();
if (empty($atts['authors'])) {
	$args = array(
		'taxonomy' => 'product_author',
		'hide_empty' => '1',
	);
	$product_authors = get_categories($args);
	$product_authors = array_slice( $product_authors, 0, $atts['items_per_page'] );
} else {
	$term_ids = $atts['authors'];
	foreach ($term_ids as $term_id) {
		$term = get_term_by( 'term_id', $term_id, 'product_author' );
		if (is_object($term)) {
			$product_authors[] = $term;
		}
	}
}
$totalRecord = count($product_authors);
if(empty($atts['image_size'])) {
	$atts['image_size'] = 'full';
}
$element->set_render_attribute('item_class', array( 'class' => $item_class ));

?>
<div <?php $element->print_render_attribute_string('wrapper') ?>>
	<?php if($totalRecord > 0): ?>
		<div class="gsf-product-authors-inner <?php echo join(' ', $inner_class); ?>" data-owl-options='<?php echo json_encode($owl_args); ?>'>
			<?php foreach ($product_authors as $author):
				$prefix = G5P()->getMetaPrefix();
				$first_name = get_term_meta($author->term_id,"{$prefix}product_author_first_name",true);
				$first_name_character = mb_substr($first_name, 0, 1);
				$last_name = get_term_meta($author->term_id,"{$prefix}product_author_last_name",true);
				$last_name_character = mb_substr($last_name, 0, 1);
				?>
				<article data-first-name="<?php echo esc_attr($first_name_character)?>" data-last-name="<?php echo esc_attr($last_name_character)?>" <?php $element->print_render_attribute_string('item_class') ?>>
					<?php
					$id = $author->term_id;
					$img = G5P()->termMeta()->get_product_author_thumb($id);
					$img_id = isset($img['id']) && !empty($img['id']) ? $img['id'] : '';?>
					<div class="entry-thumbnail-wrap">
						<a href="<?php echo esc_url(get_term_link($id, 'product_author')) ?>" title="<?php echo esc_attr($author->name) ?>"></a>
						<?php
						G5Plus_Auteur()->blog()->render_post_image_markup(array(
							'image_id'          => $img_id,
							'image_size'        => $atts['image_size'],
							'display_permalink' => false,
							'image_mode'        => 'background'
						));
						?>
					</div>
					<h6 class="gsf-product-author-name fs-13 text-center mg-top-15 uppercase fw-bold"><a href="<?php echo esc_url(get_term_link($id, 'product_author')) ?>"
					                                                                                     class="transition03 gsf-link" title="<?php echo esc_attr($author->name) ?>"><?php echo esc_html($author->name) ?></a></h6>
				</article>
			<?php endforeach; ?>
		</div>
	<?php else: ?>
		<div class="item-not-found"><?php esc_html_e('No item found','auteur-framework'); ?></div>
	<?php endif; ?>
</div>

