<?php ob_start();
if(!session_id()) session_start();
/* Signup shortcode */
add_shortcode('ask_signup', 'ask_signup_shortcode');
function ask_signup_shortcode($atts, $content = null) {
	global $user_identity,$posted;
	$a = shortcode_atts( array(
	    'dark_button' => '',
	), $atts );
	$out = '';
	if (is_user_logged_in) {
		$user_login = get_userdata(get_current_user_id());
		$out .= is_user_logged_in_data(vpanel_options("user_links"));
	}else {
		$protocol = is_ssl() ? 'https' : 'http';
		$rand_w = rand(1,1000);
		$out .= do_action('askme_social_signup').apply_filters('askme_signup_before_form',false).'
		<form method="post" class="signup_form ask_form" enctype="multipart/form-data">';
			if (shortcode_exists('askme_social_login') || shortcode_exists('rdp-linkedin-login') || shortcode_exists('oa_social_login') || shortcode_exists('wordpress_social_login') || shortcode_exists('apsl-login') || shortcode_exists('apsl-login-lite') || shortcode_exists('nextend_social_login')) {
				$out .= '<p>'.
					(shortcode_exists('askme_social_signup')?do_shortcode("[askme_social_signup]"):"").
					(shortcode_exists('rdp-linkedin-login')?do_shortcode("[rdp-linkedin-login]"):"").
					(shortcode_exists('oa_social_login')?do_shortcode("[oa_social_login]"):"").
					(shortcode_exists('wordpress_social_login')?do_shortcode("[wordpress_social_login]"):"").
					(shortcode_exists('apsl-login')?do_shortcode("[apsl-login]"):"").
					(shortcode_exists('apsl-login-lite')?do_shortcode("[apsl-login-lite]"):"").
					(shortcode_exists('nextend_social_login')?do_shortcode("[nextend_social_login]"):"").
				'</p>';
			}
			$out .= do_action('ask_signup').'
			<div class="ask_error"></div>
				<div class="form-inputs clearfix">
					<p>
						<label for="user_name_'.$rand_w.'" class="required">'.__("Username","vbegy").'<span>*</span></label>
						<input type="text" class="required-item" name="user_name" id="user_name_'.$rand_w.'" value="'.(isset($posted["user_name"])?$posted["user_name"]:"").'">
					</p>
					<p>
						<label for="email_'.$rand_w.'" class="required">'.__("E-Mail","vbegy").'<span>*</span></label>
						<input type="email" class="required-item" name="email" id="email_'.$rand_w.'" value="'.(isset($posted["email"])?$posted["email"]:"").'">
					</p>
					<p>
						<label for="pass1_'.$rand_w.'" class="required">'.__("Password","vbegy").'<span>*</span></label>
						<input type="password" class="required-item" name="pass1" id="pass1_'.$rand_w.'" autocomplete="off">
					</p>
					<p>
						<label for="pass2_'.$rand_w.'" class="required">'.__("Confirm Password","vbegy").'<span>*</span></label>
						<input type="password" class="required-item" name="pass2" id="pass2_'.$rand_w.'" autocomplete="off">
					</p>';
					$profile_picture = vpanel_options("profile_picture");
					$profile_picture_required = vpanel_options("profile_picture_required");
					if ($profile_picture == 1) {
						$out .= '<label '.($profile_picture_required == 1?'class="required"':'').' for="attachment_'.$rand_w.'">'.__('Profile Picture','vbegy').($profile_picture_required == 1?'<span>*</span>':'').'</label>
						<div class="fileinputs">
							<input type="file" name="you_avatar" id="attachment_'.$rand_w.'">
							<div class="fakefile">
								<button type="button" class="small margin_0">'.__('Select file','vbegy').'</button>
								<span><i class="icon-arrow-up"></i>'.__('Browse','vbegy').'</span>
							</div>
						</div>';
					}
					
					$country_register = vpanel_options("country_register");
					$country_required = vpanel_options("country_required");
					$city_register = vpanel_options("city_register");
					$city_required = vpanel_options("city_required");
					$age_register = vpanel_options("age_register");
					$age_required = vpanel_options("age_required");
					$phone_register = vpanel_options("phone_register");
					$phone_required = vpanel_options("phone_required");
					$sex_register = vpanel_options("sex_register");
					$sex_required = vpanel_options("sex_required");
					$names_register = vpanel_options("names_register");
					$names_required = vpanel_options("names_required");
					
					if ($names_register == 1) {
						$out .= '
						<p>
							<label for="first_name_'.$rand_w.'" '.($names_required == 1?'class="required"':'').'>'.__("First Name","vbegy").($names_required == 1?'<span>*</span>':'').'</label>
							<input name="first_name" id="first_name_'.$rand_w.'" type="text" value="'.(isset($posted["first_name"])?$posted["first_name"]:"").'">
						</p>
						<p>
							<label for="last_name_'.$rand_w.'" '.($names_required == 1?'class="required"':'').'>'.__("Last Name","vbegy").($names_required == 1?'<span>*</span>':'').'</label>
							<input name="last_name" id="last_name_'.$rand_w.'" type="text" value="'.(isset($posted["last_name"])?$posted["last_name"]:"").'">
						</p>
						<p>
							<label for="display_name_'.$rand_w.'" '.($names_required == 1?'class="required"':'').'>'.__("Display name","vbegy").($names_required == 1?'<span>*</span>':'').'</label>
							<input name="display_name" id="display_name_'.$rand_w.'" type="text" value="'.(isset($posted["display_name"])?$posted["display_name"]:"").'">
						</p>';
					}
					if ($country_register == 1) {
						$out .= '<p>
							<label for="country_'.$rand_w.'" '.($country_required == 1?'class="required"':'').'>'.__("Country","vbegy").($country_required == 1?'<span>*</span>':'').'</label>
							<span class="styled-select">
								<select name="country" id="country_'.$rand_w.'" '.($country_required == 1?'class="required-item"':'').'>
									<option value="">'.__( 'Select a country&hellip;', 'vbegy' ).'</option>';
										foreach( vpanel_get_countries() as $key => $value )
											$out .= '<option value="' . esc_attr( $key ) . '"' . (isset($posted["country"])?selected( $posted["country"], esc_attr( $key ), false ):"") . '>' . esc_html( $value ) . '</option>';
								$out .= '</select>
							</span>
						</p>';
					}
					if ($city_register == 1) {
						$out .= '<p>
							<label for="city_'.$rand_w.'" '.($city_required == 1?'class="required"':'').'>'.__("City","vbegy").($city_required == 1?'<span>*</span>':'').'</label>
							<input type="text" '.($city_required == 1?'class="required-item"':'').' name="city" id="city_'.$rand_w.'" value="'.(isset($posted["city"])?$posted["city"]:"").'">
						</p>';
					}
					if ($age_register == 1) {
						$out .= '<p>
							<label for="age_'.$rand_w.'" '.($age_required == 1?'class="required"':'').'>'.__("Age","vbegy").($age_required == 1?'<span>*</span>':'').'</label>
							<input type="text" '.($age_required == 1?'class="required-item"':'').' name="age" id="age_'.$rand_w.'" value="'.(isset($posted["age"])?$posted["age"]:"").'">
						</p>';
					}
					if ($phone_register == 1) {
						$out .= '<p>
							<label for="phone_'.$rand_w.'" '.($phone_required == 1?'class="required"':'').'>'.__("Phone","vbegy").($phone_required == 1?'<span>*</span>':'').'</label>
							<input type="text" '.($phone_required == 1?'class="required-item"':'').' name="phone" id="phone_'.$rand_w.'" value="'.(isset($posted["phone"])?$posted["phone"]:"").'">
						</p>';
					}
					$gender_other = vpanel_options("gender_other");
					if ($sex_register == 1) {
						$out .= '<p>
							<label '.($sex_required == 1?'class="required"':'').'>'.__("Gender","vbegy").($sex_required == 1?'<span>*</span>':'').'</label>
							<input id="sex_male_'.$rand_w.'" name="sex" type="radio" value="1"'.(isset($posted["sex"]) && $posted["sex"] == "1"?' checked="checked"':' checked="checked"').'>
							<label for="sex_male_'.$rand_w.'">'.__("Male","vbegy").'</label>
						</p>
						<p>
							<input id="sex_female_'.$rand_w.'" name="sex" type="radio" value="2"'.(isset($posted["sex"]) && $posted["sex"] == "2"?' checked="checked"':'').'>
							<label for="sex_female_'.$rand_w.'">'.__("Female","vbegy").'</label>
						</p>';
						if ($gender_other == 1) {
							$out .= '<p>
								<input id="sex_other_'.$rand_w.'" name="sex" type="radio" value="3"'.(isset($posted["sex"]) && $posted["sex"] == "3"?' checked="checked"':'').'>
								<label for="sex_other_'.$rand_w.'">'.__("Other","vbegy").'</label>
							</p>';
						}
					}
					
					$out .= askme_add_captcha(vpanel_options("the_captcha_register"),"register",$rand_w);
					
					$terms_active_register = vpanel_options("terms_active_register");
					if ($terms_active_register == 1) {
						$terms_checked_register = vpanel_options("terms_checked_register");
						if ((isset($posted['agree_terms']) && $posted['agree_terms'] == 1) || ($terms_checked_register == 1 && empty($posted))) {
							$active_terms = true;
						}
						$terms_link_register = vpanel_options("terms_link_register");
						$terms_page_register = vpanel_options("terms_page_register");
						$terms_active_target_register = vpanel_options("terms_active_target_register");
						$privacy_policy_register = vpanel_options('privacy_policy_register');
						$privacy_active_target_register = vpanel_options('privacy_active_target_register');
						$privacy_page_register = vpanel_options('privacy_page_register');
						$privacy_link_register = vpanel_options('privacy_link_register');
						$out .= '<p class="question_poll_p">
							<label for="agree_terms-'.$rand_w.'" class="required">'.__("Terms","vbegy").'<span>*</span></label>
							<input type="checkbox" id="agree_terms-'.$rand_w.'" name="agree_terms" value="1" '.(isset($active_terms)?"checked='checked'":"").'>
							<span class="question_poll">'.sprintf(wp_kses(__("By registering, you agree to the <a target='%s' href='%s'>terms of service</a>%s.","vbegy"),array('a' => array('href' => array(),'target' => array()))),($terms_active_target_register == "same_page"?"_self":"_blank"),(isset($terms_link_register) && $terms_link_register != ""?$terms_link_register:(isset($terms_page_register) && $terms_page_register != ""?get_page_link($terms_page_register):"#")),($privacy_policy_register == 1?" ".sprintf(wp_kses(__("and <a target='%s' href='%s'>Privacy Policy</a>","vbegy"),array('a' => array('href' => array(),'target' => array()))),($privacy_active_target_register == "same_page"?"_self":"_blank"),(isset($privacy_link_register) && $privacy_link_register != ""?$privacy_link_register:(isset($privacy_page_register) && $privacy_page_register != ""?get_page_link($privacy_page_register):"#"))):"")).'</span>
						</p>';
					}
					
				$out .= '</div>
				<p class="form-submit">
					<input type="hidden" name="redirect_to" value="'.wp_unslash( $protocol.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']).'">
					<input type="submit" name="register" value="'.__("Signup","vbegy").'" class="button color '.(isset($a["dark_button"]) && $a["dark_button"] == "dark_button"?"dark_button":"").' small submit">
					<input type="hidden" name="form_type" value="ask-signup">'.
					apply_filters("askme_signup_hidden_form",false).'
				</p>
		</form>'.apply_filters("askme_signup_after_form",false);
	}
	return $out;
}
function ask_signup_process() {
	global $posted,$vpanel_emails,$vpanel_emails_2,$vpanel_emails_3;
	$errors = new WP_Error();
	if (isset($_POST['form_type']) && $_POST['form_type'] == "ask-signup") :
		// Process signup form
		$posted = array(
			'user_name'    => esc_html($_POST['user_name']),
			'email'        => esc_html($_POST['email']),
			'pass1'        => esc_html($_POST['pass1']),
			'pass2'        => esc_html($_POST['pass2']),
			'redirect_to'  => esc_url($_POST['redirect_to']),
			'ask_captcha'  => (isset($_POST['ask_captcha']) && $_POST['ask_captcha'] != ""?esc_html($_POST['ask_captcha']):""),
			'country'      => (isset($_POST['country']) && $_POST['country'] != ""?esc_html($_POST['country']):""),
			'city'         => (isset($_POST['city']) && $_POST['city'] != ""?esc_html($_POST['city']):""),
			'age'          => (isset($_POST['age']) && $_POST['age'] != ""?esc_html($_POST['age']):""),
			'phone'        => (isset($_POST['phone']) && $_POST['phone'] != ""?esc_html($_POST['phone']):""),
			'sex'          => (isset($_POST['sex']) && $_POST['sex'] != ""?esc_html($_POST['sex']):""),
			'first_name'   => (isset($_POST['first_name']) && $_POST['first_name'] != ""?esc_html($_POST['first_name']):""),
			'last_name'    => (isset($_POST['last_name']) && $_POST['last_name'] != ""?esc_html($_POST['last_name']):""),
			'display_name' => (isset($_POST['display_name']) && $_POST['display_name'] != ""?esc_html($_POST['display_name']):""),
			'agree_terms'  => (isset($_POST['agree_terms']) && $_POST['agree_terms'] != ""?esc_html($_POST['agree_terms']):""),
		);

		$posted = apply_filters('askme_register_posted',$posted);

		$posted = array_map('stripslashes', $posted);
		$posted['username'] = sanitize_user((isset($posted['username'])?$posted['username']:""));
		// Validation
		if ( empty($posted['user_name']) ) $errors->add('required-user_name',__("Please enter your name.","vbegy"));
		if ( empty($posted['email']) ) $errors->add('required-email',__("Please enter your email.","vbegy"));
		if ( empty($posted['pass1']) ) $errors->add('required-pass1',__("Please enter your password.","vbegy"));
		if ( empty($posted['pass2']) ) $errors->add('required-pass2',__("Please rewrite password.","vbegy"));
		if ( $posted['pass1']!==$posted['pass2'] ) $errors->add('required-pass1',__("Password does not match.","vbegy"));
		
		$country_register = vpanel_options("country_register");
		$country_required = vpanel_options("country_required");
		$city_register = vpanel_options("city_register");
		$city_required = vpanel_options("city_required");
		$age_register = vpanel_options("age_register");
		$age_required = vpanel_options("age_required");
		$phone_register = vpanel_options("phone_register");
		$phone_required = vpanel_options("phone_required");
		$sex_register = vpanel_options("sex_register");
		$sex_required = vpanel_options("sex_required");
		$names_register = vpanel_options("names_register");
		$names_required = vpanel_options("names_required");
		
		askme_check_captcha(vpanel_options("the_captcha_register"),"register",$posted,$errors);

		$profile_picture = vpanel_options("profile_picture");
		$profile_picture_required = vpanel_options("profile_picture_required");
		
		if(isset($_FILES['you_avatar']) && !empty($_FILES['you_avatar']['name'])) :
			$mime = $_FILES["you_avatar"]["type"];
			if (($mime != 'image/jpeg') && ($mime != 'image/jpg') && ($mime != 'image/png')) {
				$errors->add('upload-error', esc_html__('Error type, Please upload: jpg,jpeg,png','vbegy'));
				if ($errors->get_error_code()) return $errors;
			}else {
				require_once(ABSPATH . "wp-admin" . '/includes/file.php');
				require_once(ABSPATH . "wp-admin" . '/includes/image.php');
				$you_avatar = wp_handle_upload($_FILES['you_avatar'],array('test_form'=>false),current_time('mysql'));
				if ( isset($you_avatar['error']) ) :
					$errors->add('upload-error',  __('Error in upload the image : ','vbegy') . $you_avatar['error'] );
					return $errors;
				endif;
			}
		else:
			if ($profile_picture_required == 1) {
				$errors->add('required-profile_picture', __("There are required fields ( Profile Picture ).","vbegy"));
			}
		endif;
		if (isset($you_avatar['error']) && $you_avatar) :
			if (isset($errors->add)) {
				$errors->add('upload-error', esc_html__('Error in upload the image : ','vbegy') . $you_avatar['error']);
				if ($errors->get_error_code()) return $errors;
			}
			return $errors;
		endif;
		
		if ($country_register == 1 && $country_required == 1 && empty($posted['country'])) {
			$errors->add('required-country', __("There are required fields ( Country ).","vbegy"));
		}
		if ($city_register == 1 && $city_required == 1 && empty($posted['city'])) {
			$errors->add('required-city', __("There are required fields ( City ).","vbegy"));
		}
		if ($age_register == 1 && $age_required == 1 && empty($posted['age'])) {
			$errors->add('required-age', __("There are required fields ( Age ).","vbegy"));
		}
		if ($phone_register == 1 && $phone_required == 1 && empty($posted['phone'])) {
			$errors->add('required-phone', __("There are required fields ( Phone ).","vbegy"));
		}
		if ($sex_register == 1 && $sex_required == 1 && empty($posted['sex'])) {
			$errors->add('required-sex', __("There are required fields ( Gender ).","vbegy"));
		}
		if ($names_register == 1 && $names_required == 1 && empty($posted['first_name'])) {
			$errors->add('required-first_name', __("There are required fields ( First Name ).","vbegy"));
		}
		if ($names_register == 1 && $names_required == 1 && empty($posted['last_name'])) {
			$errors->add('required-last_name', __("There are required fields ( Last Name ).","vbegy"));
		}
		if ($names_register == 1 && $names_required == 1 && empty($posted['display_name'])) {
			$errors->add('required-display_name', __("There are required fields ( Display Name ).","vbegy"));
		}
		
		$terms_active_register = vpanel_options("terms_active_register");
		if ($terms_active_register == 1 && $posted['agree_terms'] != 1) {
			$errors->add('required-terms', __("There are required fields ( Agree of the terms ).","vbegy"));
		}
		// Check the username
		if ( username_exists( $posted['user_name'] ) ) :
			$errors->add('required-user_name',__("This account is already registered.","vbegy"));
		endif;
		// Check the e-mail address
		if ( !is_email( $posted['email'] ) ) :
			$errors->add('required-email',__("Please write correctly email.","vbegy"));
		elseif ( email_exists( $posted['email'] ) ) :
			$errors->add('required-email',__("This account is already registered.","vbegy"));
		endif;
		if ( $errors->get_error_code() ) return $errors;
		if ( !$errors->get_error_code() ) :
			do_action('register_post', $posted['user_name'], $posted['email'], $errors);
			$errors = apply_filters( 'registration_errors', $errors, $posted['user_name'], $posted['email'] );
			do_action('askme_register_errors',$errors,$posted);
			// if there are no errors, let's create the user account
			if ( !$errors->get_error_code() ) :
				$user_id = wp_create_user( $posted['user_name'], $posted['pass1'], $posted['email'] );
				if (is_wp_error($user_id)) {
					$errors->add('error', sprintf(__('<strong>Error</strong>: Sorry, You can not register, Please contact the webmaster','vbegy').': ',get_option('admin_email')));
					if ( $errors->get_error_code() ) {return $errors;}
				}else {
					update_user_meta($user_id,"points",0);
					update_user_meta($user_id,"the_best_answer",0);
					if ($you_avatar && isset($you_avatar["url"])) :
						$filename = $you_avatar["file"];
						$filetype = wp_check_filetype( basename( $filename ), null );
						$wp_upload_dir = wp_upload_dir();
						
						$attachment = array(
							'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
							'post_mime_type' => $filetype['type'],
							'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
							'post_content'   => '',
							'post_status'    => 'inherit'
						);
						$attach_id = wp_insert_attachment( $attachment, $filename );
						$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
						wp_update_attachment_metadata( $attach_id, $attach_data );
						update_user_meta($user_id,"you_avatar",$attach_id);
					endif;
					if ($posted['country']) :
						update_user_meta($user_id,"country",$posted['country']);
					endif;
					if ($posted['city']) :
						update_user_meta($user_id,"city",$posted['city']);
					endif;
					if ($posted['age']) :
						update_user_meta($user_id,"age",$posted['age']);
					endif;
					if ($posted['phone']) :
						update_user_meta($user_id,"phone",$posted['phone']);
					endif;
					if ($posted['sex']) :
						update_user_meta($user_id,"sex",$posted['sex']);
					endif;
					$user_review = vpanel_options("user_review");
					if ($user_review == 1) {
						$ask_under_review = get_role("ask_under_review");
						if (!isset($ask_under_review)) {
							add_role("ask_under_review",__("Under review","vbegy"),array('read' => false));
						}
					}
					$confirm_email = vpanel_options("confirm_email");
					if ($confirm_email == 1 && $user_review != 1) {
						$activation = get_role("activation");
						if (!isset($activation)) {
							add_role("activation",esc_html__("Activation","vbegy"),array('read' => false));
						}
						wp_update_user( array ('ID' => $user_id, 'role' => 'activation', 'first_name' => $posted['first_name'], 'last_name' => $posted['last_name'], 'display_name' => $posted['display_name'],'user_nicename' => $posted['user_name'],'nickname' => $posted['user_name']) ) ;
						$rand_a = rand(1,1000000000000);
						update_user_meta($user_id,"activation",$rand_a);
						$user_data = get_user_by("id",$user_id);
						$confirm_link = esc_url(add_query_arg(array("u" => $user_id,"activate" => $rand_a),esc_url(home_url('/'))));
						$send_text = ask_send_email(vpanel_options("email_confirm_link_2"),$user_id,"","","",$confirm_link);
						$logo_email_template = vpanel_options("logo_email_template");
						$last_message_email = $vpanel_emails.($logo_email_template != ""?'<img src="'.$logo_email_template.'" alt="'.get_bloginfo('name').'">':'').$vpanel_emails_2.$send_text.$vpanel_emails_3;
						$email_title = vpanel_options("title_confirm_link_2");
						$email_title = ($email_title != ""?$email_title:__("Confirm account","vbegy"));
						askme_sendEmail(vpanel_options("email_template"),get_bloginfo('name'),esc_html($_POST['email']),esc_html($_POST['user_name']),$email_title,$last_message_email);
					}else {
						$default_group = vpanel_options("default_group");
						$default_group = (isset($default_group) && $default_group != ""?$default_group:"subscriber");
						$default_group = ($user_review == 1?"ask_under_review":$default_group);
						$default_group = apply_filters("askme_register_default_group",$default_group);
						wp_update_user( array ('ID' => $user_id, 'role' => $default_group, 'first_name' => $posted['first_name'], 'last_name' => $posted['last_name'], 'display_name' => $posted['display_name'],'user_nicename' => $posted['user_name'],'nickname' => $posted['user_name']) ) ;
					}
					$point_new_user = vpanel_options("point_new_user");
					$active_points = vpanel_options("active_points");
					if ($point_new_user > 0 && $active_points == 1 && $confirm_email != 1) {
						$current_user = get_user_by("id",$user_id);
						$_points = get_user_meta($user_id,$current_user->user_login."_points",true);
						$_points++;
						
						update_user_meta($user_id,$current_user->user_login."_points",$_points);
						add_user_meta($user_id,$current_user->user_login."_points_".$_points,array(date_i18n('Y/m/d',current_time('timestamp')),date_i18n('g:i a',current_time('timestamp')),$point_new_user,"+","gift_site",$post_id,$id));
					
						$points_user = get_user_meta($user_id,"points",true);
						update_user_meta($user_id,"points",$points_user+$point_new_user);
						
						askme_notifications_activities($user_id,"","","","","gift_site","notifications");
					}

					do_action('askme_after_register',$user_id,$posted,isset($_FILES)?$_FILES:array());

					$secure_cookie = is_ssl() ? true : false;
					wp_set_auth_cookie($user_id, true, $secure_cookie);
					
					$after_register = vpanel_options("after_register");
					$after_register_link = vpanel_options("after_register_link");
					
					if (isset($posted['redirect_to']) && $after_register == "same_page") {
						$redirect_to = $posted['redirect_to'];
					}else if (isset($user_id) && $user_id > 0 && $after_register == "profile") {
						$redirect_to = vpanel_get_user_url($user_id);
					}else if ($after_register == "custom_link") {
						$redirect_to = esc_url($after_register_link);
					}else {
						$redirect_to = esc_url(home_url('/'));
					}
					wp_safe_redirect($redirect_to);
					exit;
				}
			endif;
		endif;
	endif;
	return;
}
add_action('user_register','ask_registration_save',10,1);
function ask_registration_save ($user_id) {
	$point_new_user = vpanel_options("point_new_user");
	$active_points = vpanel_options("active_points");
	if (is_user_logged_in && $point_new_user > 0 && $active_points == 1) {
		$current_user = get_user_by("id",$user_id);
		$_points = get_user_meta($user_id,$current_user->user_login."_points",true);
		$_points++;
	
		update_user_meta($user_id,$current_user->user_login."_points",$_points);
		add_user_meta($user_id,$current_user->user_login."_points_".$_points,array(date_i18n('Y/m/d',current_time('timestamp')),date_i18n('g:i a',current_time('timestamp')),$point_new_user,"+","gift_site",$post_id,$id));
	
		$points_user = get_user_meta($user_id,"points",true);
		update_user_meta($user_id,"points",$points_user+$point_new_user);
		
		askme_notifications_activities($user_id,"","","","","gift_site","notifications");
	}
}
function ask_signup() {
	if (isset($_POST['form_type']) && $_POST['form_type'] == "ask-signup") :
		$return = ask_signup_process();
		if (is_wp_error($return) ) :
			echo '<div class="ask_error"><strong><p>'.__("Error","vbegy").' :&nbsp;</strong>'.wptexturize(str_replace('<strong>'.__("Error","vbegy").'</strong>: ', '', $return->get_error_message())).'</p></div>';
   		endif;
	endif;
}
add_action('ask_signup', 'ask_signup');?>