<?php ob_start();
if(!session_id()) session_start();
$settings = array("textarea_name" => "comment","media_buttons" => true,"textarea_rows" => 10);
/* is_user_logged_in_data */
function is_user_logged_in_data ($user_links = array("profile" => 1,"messages" => 1,"questions" => 1,"asked_questions" => 1,"paid_questions" => 1,"answers" => 1,"favorite" => 1,"followed" => 1,"points" => 1,"i_follow" => 1,"followers" => 1,"posts" => 1,"follow_questions" => 1,"follow_answers" => 1,"follow_posts" => 1,"follow_comments" => 1,"edit_profile" => 1,"logout" => 1),$profile_widget = "") {
	$out = '';
	if (is_user_logged_in) {
		$user_login = get_userdata(get_current_user_id());
		$you_avatar = get_the_author_meta('you_avatar',$user_login->ID);
		$url = get_the_author_meta('url',$user_login->ID);
		$twitter = get_the_author_meta('twitter',$user_login->ID);
		$facebook = get_the_author_meta('facebook',$user_login->ID);
		$youtube = get_the_author_meta('youtube',$user_login->ID);
		$linkedin = get_the_author_meta('linkedin',$user_login->ID);
		$follow_email = get_the_author_meta('follow_email',$user_login->ID);
		$country = get_the_author_meta('country',$user_login->ID);
		$city = get_the_author_meta('city',$user_login->ID);
		$phone = get_the_author_meta('phone',$user_login->ID);
		$age = get_the_author_meta('age',$user_login->ID);
		$sex = get_the_author_meta('sex',$user_login->ID);
		$verified_user = get_the_author_meta('verified_user',$user_login->ID);
		$out .= '<div class="row">';
			if ($profile_widget != "on") {
				$out .= '<div class="col-md-8">
					<div class="is-login-left user-profile-img">
						<a original-title="'.$user_login->display_name.'" class="tooltip-n" href="'.vpanel_get_user_url($user_login->ID).'">
							'.askme_user_avatar($you_avatar,79,79,$user_login->ID,$user_login->display_name).'
						</a>
					</div>
					<div class="is-login-right">
						<h2>'.__("Welcome","vbegy").' '.$user_login->display_name.($verified_user == 1?'<img class="verified_user tooltip-n" alt="'.__("Verified","vbegy").'" original-title="'.__("Verified","vbegy").'" src="'.get_template_directory_uri().'/images/verified.png">':'').vpanel_get_badge($user_login->ID).'</h2>';
						if (isset($user_login->description) && $user_login->description != "") {
							$out .= '<p>'.$user_login->description.'</p>';
						}
						if ($youtube || $facebook || $twitter || $linkedin || $follow_email) {
							$out .= '<div class="social_icons social_icons_display">';
								if ($facebook) {
									$out .= '<a href="'.$facebook.'" original-title="'.__("Facebook","vbegy").'" class="tooltip-n">
										<span class="icon_i">
											<span class="icon_square" icon_size="30" span_bg="#3b5997">
												<i class="social_icon-facebook"></i>
											</span>
										</span>
									</a>';
								}
								if ($twitter) {
									$out .= '<a href="'.$twitter.'" original-title="'.__("Twitter","vbegy").'" class="tooltip-n">
										<span class="icon_i">
											<span class="icon_square" icon_size="30" span_bg="#00baf0">
												<i class="social_icon-twitter"></i>
											</span>
										</span>
									</a>';
								}
								if ($youtube) {
									$out .= '<a href="'.$youtube.'" original-title="'.__("Youtube","vbegy").'" class="tooltip-n">
										<span class="icon_i">
											<span class="icon_square" icon_size="30" span_bg="#c4302b">
												<i class="social_icon-youtube"></i>
											</span>
										</span>
									</a>';
								}
								if ($linkedin) {
									$out .= '<a href="'.$linkedin.'" original-title="'.__("Linkedin","vbegy").'" class="tooltip-n">
										<span class="icon_i">
											<span class="icon_square" icon_size="30" span_bg="#006599">
												<i class="social_icon-linkedin"></i>
											</span>
										</span>
									</a>';
								}
								if ($follow_email) {
									$out .= '<a href="mailto:'.$user_login->user_email.'" original-title="'.__("Email","vbegy").'" class="tooltip-n">
										<span class="icon_i">
											<span class="icon_square" icon_size="30" span_bg="#000">
												<i class="social_icon-email"></i>
											</span>
										</span>
									</a>';
								}
							$out .= '</div>';
						}
					$out .= '</div>
				</div>';
			}
			
			$get_lang = esc_attr(get_query_var("lang"));
			$get_lang_array = array();
			if (isset($get_lang) && $get_lang != "") {
				$get_lang_array = array("lang" => $get_lang);
			}
			
			$out .= '<div class="'.($profile_widget != "on"?"col-md-4":"col-md-12").'">';
				$active_points = vpanel_options("active_points");
				if (isset($user_links) && is_array($user_links) && ((isset($user_links["profile"]) && ($user_links["profile"] == 1 || $user_links["profile"] == "on")) || (isset($user_links["messages"]) && ($user_links["messages"] == 1 || $user_links["messages"] == "on")) || (isset($user_links["questions"]) && ($user_links["questions"] == 1 || $user_links["questions"] == "on")) || (isset($user_links["polls"]) && ($user_links["polls"] == 1 || $user_links["polls"] == "on")) || (isset($user_links["best_answers"]) && ($user_links["best_answers"] == 1 || $user_links["best_answers"] == "on")) || (isset($user_links["asked_questions"]) && ($user_links["asked_questions"] == 1 || $user_links["asked_questions"] == "on")) || (isset($user_links["paid_questions"]) && ($user_links["paid_questions"] == 1 || $user_links["paid_questions"] == "on")) || (isset($user_links["answers"]) && ($user_links["answers"] == 1 || $user_links["answers"] == "on")) || (isset($user_links["favorite"]) && ($user_links["favorite"] == 1 || $user_links["favorite"] == "on")) || (isset($user_links["followed"]) && ($user_links["followed"] == 1 || $user_links["followed"] == "on")) || (isset($user_links["points"]) && ($user_links["points"] == 1 || $user_links["points"] == "on")) || (isset($user_links["i_follow"]) && ($user_links["i_follow"] == 1 || $user_links["i_follow"] == "on")) || (isset($user_links["followers"]) && ($user_links["followers"] == 1 || $user_links["followers"] == "on")) || (isset($user_links["posts"]) && ($user_links["posts"] == 1 || $user_links["posts"] == "on")) || (isset($user_links["follow_questions"]) && ($user_links["follow_questions"] == 1 || $user_links["follow_questions"] == "on")) || (isset($user_links["follow_answers"]) && ($user_links["follow_answers"] == 1 || $user_links["follow_answers"] == "on")) || (isset($user_links["follow_posts"]) && ($user_links["follow_posts"] == 1 || $user_links["follow_posts"] == "on")) || (isset($user_links["follow_comments"]) && ($user_links["follow_comments"] == 1 || $user_links["follow_comments"] == "on")) || (isset($user_links["edit_profile"]) && ($user_links["edit_profile"] == 1 || $user_links["edit_profile"] == "on")) || (isset($user_links["logout"]) && ($user_links["logout"] == 1 || $user_links["logout"] == "on")))) {
					if ($profile_widget != "on") {
						$out .= '<h2>'.__("Quick Links","vbegy").'</h2>';
					}
					$out .= '<ul class="user_quick_links">';
						if (isset($user_links) && is_array($user_links) && ((isset($user_links["profile"]) && ($user_links["profile"] == 1 || $user_links["profile"] == "on")) || (isset($user_links["messages"]) && ($user_links["messages"] == 1 || $user_links["messages"] == "on")) || (isset($user_links["questions"]) && ($user_links["questions"] == 1 || $user_links["questions"] == "on")) || (isset($user_links["polls"]) && ($user_links["polls"] == 1 || $user_links["polls"] == "on")) || (isset($user_links["best_answers"]) && ($user_links["best_answers"] == 1 || $user_links["best_answers"] == "on")) || (isset($user_links["asked_questions"]) && ($user_links["asked_questions"] == 1 || $user_links["asked_questions"] == "on")) || (isset($user_links["answers"]) && ($user_links["answers"] == 1 || $user_links["answers"] == "on")) || (isset($user_links["favorite"]) && ($user_links["favorite"] == 1 || $user_links["favorite"] == "on")) || (isset($user_links["followed"]) && ($user_links["followed"] == 1 || $user_links["followed"] == "on")) || (isset($user_links["points"]) && ($user_links["points"] == 1 || $user_links["points"] == "on")) || (isset($user_links["i_follow"]) && ($user_links["i_follow"] == 1 || $user_links["i_follow"] == "on")) || (isset($user_links["followers"]) && ($user_links["followers"] == 1 || $user_links["followers"] == "on")))) {
							if (isset($user_links) && is_array($user_links) && (isset($user_links["profile"]) && ($user_links["profile"] == 1 || $user_links["profile"] == "on"))) {
								$out .= '<li><a href="'.vpanel_get_user_url($user_login->ID).'"><i class="icon-home"></i>'.__("Profile page","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["messages"]) && ($user_links["messages"] == 1 || $user_links["messages"] == "on"))) {
								$out .= '<li><a href="'.esc_url(get_page_link(vpanel_options('messages_page'))).'"><i class="icon-envelope-alt"></i>'.__("Messages","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["questions"]) && ($user_links["questions"] == 1 || $user_links["questions"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('question_user_page')))).'"><i class="icon-question-sign"></i>'.__("Questions","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["polls"]) && ($user_links["polls"] == 1 || $user_links["polls"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('polls_user_page')))).'"><i class="icon-question-sign"></i>'.__("Polls","vbegy").'</a></li>';
							}
							$ask_question_to_users = vpanel_options("ask_question_to_users");
							if ($ask_question_to_users == 1 && isset($user_links) && is_array($user_links) && (isset($user_links["asked_questions"]) && ($user_links["asked_questions"] == 1 || $user_links["asked_questions"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('asked_question_user_page')))).'"><i class="icon-question-sign"></i>'.__("Asked Questions","vbegy").'</a></li>';
							}
							$pay_ask = vpanel_options("pay_ask");
							if ($pay_ask == 1 && isset($user_links) && is_array($user_links) && (isset($user_links["paid_questions"]) && ($user_links["paid_questions"] == 1 || $user_links["paid_questions"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg("u", esc_attr($user_login->ID),get_page_link(vpanel_options('paid_question')))).'"><i class="icon-shopping-cart"></i>'.__("Paid question","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["answers"]) && ($user_links["answers"] == 1 || $user_links["answers"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('answer_user_page')))).'"><i class="fa fa-comments-o"></i>'.__("Answers","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["best_answers"]) && ($user_links["best_answers"] == 1 || $user_links["best_answers"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('best_answer_user_page')))).'"><i class="fa fa-comments-o"></i>'.__("Best Answers","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["favorite"]) && ($user_links["favorite"] == 1 || $user_links["favorite"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('favorite_user_page')))).'"><i class="icon-star"></i>'.__("Favorite Questions","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["followed"]) && ($user_links["followed"] == 1 || $user_links["followed"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('followed_user_page')))).'"><i class="icon-question-sign"></i>'.__("Followed Questions","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["points"]) && ($user_links["points"] == 1 || $user_links["points"] == "on")) && $active_points == 1) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('point_user_page')))).'"><i class="icon-heart"></i>'.__("Points","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["i_follow"]) && ($user_links["i_follow"] == 1 || $user_links["i_follow"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('i_follow_user_page')))).'"><i class="icon-user-md"></i>'.__("Authors I Follow","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["followers"]) && ($user_links["followers"] == 1 || $user_links["followers"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('followers_user_page')))).'"><i class="icon-user"></i>'.__("Followers","vbegy").'</a></li>';
							}
						}
						if (isset($user_links) && is_array($user_links) && ((isset($user_links["posts"]) && ($user_links["posts"] == 1 || $user_links["posts"] == "on")) || (isset($user_links["comments"]) && ($user_links["comments"] == 1 || $user_links["comments"] == "on")) || (isset($user_links["follow_questions"]) && ($user_links["follow_questions"] == 1 || $user_links["follow_questions"] == "on")) || (isset($user_links["follow_answers"]) && ($user_links["follow_answers"] == 1 || $user_links["follow_answers"] == "on")) || (isset($user_links["follow_posts"]) && ($user_links["follow_posts"] == 1 || $user_links["follow_posts"] == "on")) || (isset($user_links["follow_comments"]) && ($user_links["follow_comments"] == 1 || $user_links["follow_comments"] == "on")) || (isset($user_links["edit_profile"]) && ($user_links["edit_profile"] == 1 || $user_links["edit_profile"] == "on")) || (isset($user_links["logout"]) && ($user_links["logout"] == 1 || $user_links["logout"] == "on")))) {
							if (isset($user_links) && is_array($user_links) && (isset($user_links["posts"]) && ($user_links["posts"] == 1 || $user_links["posts"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('post_user_page')))).'"><i class="icon-file-alt"></i>'.__("Posts","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["comments"]) && ($user_links["comments"] == 1 || $user_links["comments"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('comment_user_page')))).'"><i class="fa fa-comments"></i>'.__("Comments","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["follow_questions"]) && ($user_links["follow_questions"] == 1 || $user_links["follow_questions"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('follow_question_page')))).'"><i class="icon-question-sign"></i>'.__("Follow questions","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["follow_answers"]) && ($user_links["follow_answers"] == 1 || $user_links["follow_answers"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('follow_answer_page')))).'"><i class="fa fa-comments-o"></i>'.__("Follow answers","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["follow_posts"]) && ($user_links["follow_posts"] == 1 || $user_links["follow_posts"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('follow_post_page')))).'"><i class="icon-file-alt"></i>'.__("Follow posts","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["follow_comments"]) && ($user_links["follow_comments"] == 1 || $user_links["follow_comments"] == "on"))) {
								$out .= '<li><a href="'.esc_url(add_query_arg(array_merge(array("u" => esc_attr($user_login->ID),$get_lang_array)),get_page_link(vpanel_options('follow_comment_page')))).'"><i class="fa fa-comments-o"></i>'.__("Follow comments","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["activity_log"]) && ($user_links["activity_log"] == 1 || $user_links["activity_log"] == "on"))) {
								$out .= '<li><a href="'.esc_url(get_page_link(vpanel_options('activity_log_page'))).'"><i class="fa fa-thumb-tack"></i>'.__("Activity log","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["edit_profile"]) && ($user_links["edit_profile"] == 1 || $user_links["edit_profile"] == "on"))) {
								$out .= '<li><a href="'.esc_url(get_page_link(vpanel_options('user_edit_profile_page'))).'"><i class="icon-pencil"></i>'.__("Edit profile","vbegy").'</a></li>';
							}
							if (isset($user_links) && is_array($user_links) && (isset($user_links["logout"]) && ($user_links["logout"] == 1 || $user_links["logout"] == "on"))) {
								$protocol = is_ssl() ? 'https' : 'http';
								$out .= '<li><a href="'.askme_get_logout().'"><i class="icon-signout"></i>'.__("Logout","vbegy").'</a></li>';
							}
						}
					$out .= '</ul>';
				}
			$out .= '</div><!-- End col-md-4 -->
		</div><!-- End row -->';
	}else {
		$out .= '<div class="form-style form-style-3">
			'.do_shortcode("[ask_login]").'
		</div>';
	}
	return $out;
}
/* Login shortcode */
function ask_login ($atts, $content = null) {
	global $user_identity,$user_ID;
	$protocol = is_ssl() ? 'https' : 'http';
	$a = shortcode_atts( array(
	    'forget' => 'forget',
	    'register' => '',
	    'register_2' => '',
	), $atts );
	$out = '';
	if (is_user_logged_in) :
		$user_login = get_userdata(get_current_user_id());
		$out .= is_user_logged_in_data(vpanel_options("user_links"));
	else:
		$ajax_file = vpanel_options("ajax_file");
		$ajax_file = ($ajax_file == "theme"?get_template_directory_uri().'/includes/ajax.php':admin_url("admin-ajax.php"));
		$out .= do_action('askme_social_login').do_action('oa_social_login').(shortcode_exists('wordpress_social_login')?'<div class="clearfix"></div><br>'.do_shortcode("[wordpress_social_login]"):"").(shortcode_exists('apsl-login')?'<div class="clearfix"></div><br>'.do_shortcode("[apsl-login]"):"").(shortcode_exists('apsl-login-lite')?'<div class="clearfix"></div><br>'.do_shortcode("[apsl-login-lite]"):"").(shortcode_exists('nextend_social_login')?'<div class="clearfix"></div><br>'.do_shortcode("[nextend_social_login]"):"").'<div class="ask_form inputs">
			<form class="login-form ask_login" action="'.home_url('/').'" method="post">
				<div class="ask_error"></div>
				
				<div class="form-inputs clearfix">
					<p class="login-text">
						<input class="required-item" type="text" placeholder="'.__("Username","vbegy").'" name="log">
						<i class="icon-user"></i>
					</p>
					<p class="login-password">
						<input class="required-item" type="password" placeholder="'.__("Password","vbegy").'" name="pwd">
						<i class="icon-lock"></i>
						'.(isset($a["forget"]) && $a["forget"] == "false"?'':'<a href="#">'.__("Forget","vbegy").'</a>').'
					</p>
					'.askme_add_captcha(vpanel_options("the_captcha_login"),"login",rand(1,1000)).'
				</div>
				
				<p class="form-submit login-submit">
					<span class="loader_2"></span>
					<input type="submit" value="'.__("Log in","vbegy").'" class="button color small login-submit submit sidebar_submit">
					'.(isset($a["register"]) && $a["register"] == "button"?'<input type="button" class="signup button color small submit sidebar_submit" value="'.__("Register","vbegy").'">':'').'
				</p>
				
				<div class="rememberme">
					<label><input type="checkbox"input name="rememberme" checked="checked"> '.__("Remember Me","vbegy").'</label>
				</div>
				
				<input type="hidden" name="redirect_to" value="'.wp_unslash( $protocol.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']).'">
				<input type="hidden" name="login_nonce" value="'.wp_create_nonce("ask-login-action").'">
				<input type="hidden" name="ajax_url" value="'.$ajax_file.'">
				<input type="hidden" name="form_type" value="ask-login">
				<div class="errorlogin"></div>
			</form>
		</div>'.(isset($a["register_2"]) && $a["register_2"] == "yes"?"<ul class='login-links login-links-r'><li><a href='#'>".__("Register","vbegy")."</a></li></ul>":"");
	endif;
	return $out;
}
function ask_login_shortcode() {
	add_shortcode("ask_login","ask_login");
}
add_action("init","ask_login_shortcode");
//add_filter("the_content","do_shortcode");
add_filter("widget_text","do_shortcode");
function ask_login_jquery() {
	if (isset($_REQUEST['redirect_to'])) {
		$redirect_to = $_REQUEST['redirect_to'];
	}
	$after_login = vpanel_options("after_login");
	$after_login_link = vpanel_options("after_login_link");
	
	if ( is_ssl() && force_ssl_admin() && !force_ssl_admin() && ( 0 !== strpos($redirect_to, 'https') ) && ( 0 === strpos($redirect_to, 'http') ) )$secure_cookie = false; else $secure_cookie = '';
	
	// Check the username
	if ( !isset($_POST['log']) ) :
		$user = new WP_Error();
		$user->add('empty_username', __('<strong>Error :&nbsp;</strong>please insert your name .','vbegy'));
	elseif ( !isset($_POST['pwd']) ) :
		$error = new WP_Error();
		$user->add('empty_username', __('<strong>Error :&nbsp;</strong>please insert your password .','vbegy'));
	endif;
	
	wp_clear_auth_cookie();
	$data                  = array();
	$data['user_login']    = $_POST['log'];
	$data['user_password'] = $_POST['pwd'];
	$data['remember']      = $_POST['rememberme'];
	$secure_cookie         = is_ssl() ? true : false;
	$user = wp_signon($data,$secure_cookie);
	
	if (isset($_REQUEST['redirect_to']) && $after_login == "same_page") {
		$redirect_to = $_REQUEST['redirect_to'];
	}else if (isset($user->ID) && $user->ID > 0 && $after_login == "profile") {
		$redirect_to = vpanel_get_user_url($user->ID);
	}else if ($after_login == "custom_link") {
		$redirect_to = esc_url($after_login_link);
	}else {
		$redirect_to = esc_url(home_url('/'));
	}

	if (ask_is_ajax()) :
		// Result
		$result = array();
		if ( !is_wp_error($user) ) :
			$result['success'] = 1;
			$result['redirect'] = $redirect_to;
		else :
			$result['success'] = 0;
			foreach ($user->errors as $error) {
				$result['error'] = $error[0];
				break;
			}
		endif;
		echo json_encode($result);
		die();
	else :
		if ( !is_wp_error($user) ) :
			wp_redirect($redirect_to);
			exit;
		endif;
	endif;
	return $user;
}
if (!function_exists('ask_is_ajax')) {
	function ask_is_ajax() {
		if (defined('DOING_AJAX')) return true;
		if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') return true;
		return false;
	}
}
function ask_login_process() {
	global $ask_login_errors;
	if (isset($_POST['login-form']) && $_POST['login-form']) :
		$ask_login_errors = ask_login_jquery();
	endif;
}
add_action('init','ask_login_process');
function ask_ajax_login_process() {
	check_ajax_referer( 'ask-login-action', 'security' );
	ask_login_jquery();
	die();
}
add_action('wp_ajax_ask_ajax_login_process','ask_ajax_login_process');
add_action('wp_ajax_nopriv_ask_ajax_login_process','ask_ajax_login_process');
/* Lostpassword shortcode */
add_shortcode('ask_lost_pass', 'ask_lost_pass');
function ask_lost_pass($atts, $content = null) {
	global $user_identity;
	$a = shortcode_atts( array(
	    'dark_button' => '',
	), $atts );
	$out = '';
	if (is_user_logged_in) :
		$user_login = get_userdata(get_current_user_id());
		$out .= is_user_logged_in_data(vpanel_options("user_links"));
	else:
		do_action('ask_lost_password');
		$rand_w = rand(1,1000);
		$out .= '
		<form method="post" class="ask-lost-password ask_form" action="">
			<div class="ask_error"></div>
			<div class="form-inputs clearfix">
				<p>
					<label for="user_mail_'.$rand_w.'" class="required">'.__("E-Mail","vbegy").'<span>*</span></label>
					<input type="email" class="required-item" name="user_mail" id="user_mail_'.$rand_w.'">
				</p>
				'.askme_add_captcha(vpanel_options("the_captcha_password"),"password",rand(1,1000)).'
			</div>
			<p class="form-submit">
				<input type="submit" value="'.__("Reset","vbegy").'" class="button color '.(isset($a["dark_button"]) && $a["dark_button"] == "dark_button"?"dark_button":"").' small submit">
				<input type="hidden" name="form_type" value="ask-forget">
			</p>
		</form>';
	endif;
	return $out;
}
function ask_process_lost_pass() {
	global $posted,$wpdb,$vpanel_emails,$vpanel_emails_2,$vpanel_emails_3;
	$errors = new WP_Error();
	$fields = array('user_mail','form_type','ask_captcha');
	
	foreach ($fields as $field) :
		if (isset($_POST[$field])) $posted[$field] = $_POST[$field]; else $posted[$field] = '';
	endforeach;
	
	$posted = array_map('stripslashes', $posted);
	
	if ( is_user_logged_in ) :
		$user_id = get_current_user_id();
		$errors->add('already_logged', sprintf(wp_kses(__("You are already logged in, If you want to change your password go to <a href='%s'>edit profile</a>.","vbegy"),array('a' => array('href' => array()))),esc_url(get_page_link(vpanel_options('user_edit_profile_page')))));
	elseif ( empty($posted['user_mail']) ) :
		$errors->add('empty_email', sprintf(esc_html__('Please insert your email.','vbegy'),'<strong>','</strong>'));
	elseif ( !email_exists($posted['user_mail']) ) :
		$errors->add('invalid_email', sprintf(esc_html__('There is no user registered with that email address.','vbegy'),'<strong>','</strong>'));
	endif;

	askme_check_captcha(vpanel_options("the_captcha_password"),"password",$posted,$errors);
	
	$get_user_by_mail = get_user_by('email',$posted['user_mail']);
	if ( $errors->get_error_code() ) return $errors;
	if ($_POST['form_type']) {
		unset($_POST["form_type"]);
	}
	$rand_a = rand(1,1000000000000);
	$get_reset_password = get_user_meta($get_user_by_mail->ID,"reset_password",true);
	if ($get_reset_password == "") {
		update_user_meta($get_user_by_mail->ID,"reset_password",$rand_a);
		$get_reset_password = $rand_a;
	}
	$confirm_link_email = esc_url(add_query_arg(array("u" => $get_user_by_mail->ID,"reset_password" => $get_reset_password),esc_url(home_url('/'))));
	$send_text = ask_send_email(vpanel_options("email_new_password"),$get_user_by_mail->ID,"","","",$confirm_link_email);
	$logo_email_template = vpanel_options("logo_email_template");
	$last_message_email = $vpanel_emails.($logo_email_template != ""?'<img src="'.$logo_email_template.'" alt="'.get_bloginfo('name').'">':'').$vpanel_emails_2.$send_text.$vpanel_emails_3;
	$email_title = vpanel_options("title_new_password");
	$email_title = ($email_title != ""?$email_title:__("Reset your password","vbegy"));
	askme_sendEmail(vpanel_options("email_template"),get_bloginfo('name'),esc_html($posted['user_mail']),esc_html($get_user_by_mail->display_name),$email_title,$last_message_email);
	return;
}
function ask_lost_pass_word() {
	if (isset($_POST['form_type']) && $_POST['form_type'] == "ask-forget") :
		$return = ask_process_lost_pass();
		if ( is_wp_error($return) ) :
   			echo '<div class="ask_error"><strong>'.__("Error","vbegy").' :&nbsp;'.$return->get_error_message().'</strong></div>';
   		else :
   			echo '<div class="ask_done"><strong>'.__("Check your email please.","vbegy").'</strong></div>';
   		endif;
	endif;
}
add_action('ask_lost_password', 'ask_lost_pass_word');
/* Generate random code */
function ask_generate_random($length = 6, $letters = '1234567890qwertyuiopasdfghjklzxcvbnm') {
	$s = '';
	$lettersLength = strlen($letters)-1;
	for($i = 0 ; $i < $length ; $i++) {
		$s .= $letters[rand(0,$lettersLength)];
	}
	return $s;
}
/* hex2rgb */
function hex2rgb ($hex) {
   $hex = str_replace("#","",$hex);
   if (strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   }else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return $rgb;
}
/* ask_edit_profile_shortcode */
add_shortcode('ask_edit_profile', 'ask_edit_profile_shortcode');
function ask_edit_profile_shortcode($atts, $content = null) {
	global $user_identity,$posted,$public_display;
	$out = '';
	if (!is_user_logged_in) {
		$out .= '<div class="note_error"><strong>'.__("Please login to edit profile .","vbegy").'</strong></div>
		<div class="form-style form-style-3">
			'.do_shortcode("[ask_login register_2='yes']").'
		</div>';
	}else {
		do_action('ask_edit_profile_form');
		$out .= '<form class="edit-profile-form vpanel_form" method="post" enctype="multipart/form-data">';
		
			$user_info = get_userdata(get_current_user_id());
			$you_avatar = get_the_author_meta('you_avatar',$user_info->ID);
			$url = get_the_author_meta('url',$user_info->ID);
			$twitter = get_the_author_meta('twitter',$user_info->ID);
			$facebook = get_the_author_meta('facebook',$user_info->ID);
			$youtube = get_the_author_meta('youtube',$user_info->ID);
			$linkedin = get_the_author_meta('linkedin',$user_info->ID);
			$follow_email = get_the_author_meta('follow_email',$user_info->ID);
			$follow_email = ($follow_email != ""?1:0);
			$display_name = get_the_author_meta('display_name',$user_info->ID);
			$country = get_the_author_meta('country',$user_info->ID);
			$city = get_the_author_meta('city',$user_info->ID);
			$age = get_the_author_meta('age',$user_info->ID);
			$phone = get_the_author_meta('phone',$user_info->ID);
			$sex = get_the_author_meta('sex',$user_info->ID);
			$instagram = get_the_author_meta('instagram',$user_info->ID);
			$pinterest = get_the_author_meta('pinterest',$user_info->ID);
			
			$show_point_favorite = get_the_author_meta('show_point_favorite',$user_info->ID);
			$received_email = get_the_author_meta('received_email',$user_info->ID);
			$received_message = get_the_author_meta('received_message',$user_info->ID);
			$names_profile = vpanel_options("names_profile");
			$names_required_profile = vpanel_options("names_required_profile");
			$phone_profile = vpanel_options("phone_profile");
			$phone_required_profile = vpanel_options("phone_required_profile");
			
			$country_profile = vpanel_options("country_profile");
			$country_required_profile = vpanel_options("country_required_profile");
			$city_profile = vpanel_options("city_profile");
			$city_required_profile = vpanel_options("city_required_profile");
			$age_profile = vpanel_options("age_profile");
			$age_required_profile = vpanel_options("age_required_profile");
			$sex_profile = vpanel_options("sex_profile");
			$sex_required_profile = vpanel_options("sex_required_profile");
			$url_profile = vpanel_options("url_profile");
			$url_required_profile = vpanel_options("url_required_profile");
			
			$out .= '<div class="form-inputs clearfix">
				<p>
					<label>'.__("Nickname","vbegy").'</label>
					<input name="nickname" id="nickname" type="text" value="'.$user_info->nickname.'">
				</p>';
				if ($names_profile == 1) {
					$out .= '
					<p>
						<label '.($names_required_profile == 1?'class="required"':'').'>'.__("First Name","vbegy").($names_required_profile == 1?'<span>*</span>':'').'</label>
						<input name="first_name" id="first_name" type="text" value="'.$user_info->first_name.'">
					</p>
					<p>
						<label '.($names_required_profile == 1?'class="required"':'').'>'.__("Last Name","vbegy").($names_required_profile == 1?'<span>*</span>':'').'</label>
						<input name="last_name" id="last_name" type="text" value="'.$user_info->last_name.'">
					</p>
					<p>
						<label '.($names_required_profile == 1?'class="required"':'').'>'.__("Display name","vbegy").($names_required_profile == 1?'<span>*</span>':'').'</label>
						<input name="display_name" id="display_name" type="text" value="'.$user_info->display_name.'">
					</p>';
				}
				
				$out .= '<p>
					<label for="email" class="required">'.__("E-Mail","vbegy").'<span>*</span></label>
					<input name="email" id="email" type="email" value="'.$user_info->user_email.'">
				</p>
				<p>
					<label for="newpassword" class="required">'.__("Password","vbegy").'<span>*</span></label>
					<input name="pass1" id="newpassword" type="password" value="">
				</p>
				<p>
					<label for="newpassword2" class="required">'.__("Confirm Password","vbegy").'<span>*</span></label>
					<input name="pass2" id="newpassword2" type="password" value="">
				</p>';
				
				if ($phone_profile == 1) {
					$out .= '<p>
						<label for="phone" '.($phone_required_profile == 1?'class="required"':'').'>'.__("Phone","vbegy").($phone_required_profile == 1?'<span>*</span>':'').'</label>
						<input type="text" '.($phone_required_profile == 1?'class="required-item"':'').' name="phone" id="phone" value="'.$phone.'">
					</p>';
				}
				
				if ($country_profile == 1) {
					$out .= '
					<p>
						<label for="country" '.($country_required_profile == 1?'class="required"':'').'>'.__("Country","vbegy").($country_required_profile == 1?'<span>*</span>':'').'</label>
						<span class="styled-select">
							<select name="country" id="country" '.($country_required_profile == 1?'class="required-item"':'').'>
								<option value="">'.__( 'Select a country&hellip;', 'vbegy' ).'</option>';
									foreach( vpanel_get_countries() as $key => $value )
										$out .= '<option value="' . esc_attr( $key ) . '"' . selected( $country, esc_attr( $key ), false ) . '>' . esc_html( $value ) . '</option>';
							$out .= '</select>
						</span>
					</p>';
				}
				if ($city_profile == 1) {
					$out .= '<p>
						<label for="city" '.($city_required_profile == 1?'class="required"':'').'>'.__("City","vbegy").($city_required_profile == 1?'<span>*</span>':'').'</label>
						<input type="text" '.($city_required_profile == 1?'class="required-item"':'').' name="city" id="city" value="'.$city.'">
					</p>';
				}
				
				$out .= apply_filters('askme_edit_profile_after_city',false,(isset($_POST)?$_POST:array()),$user_info->ID);
				
				if ($age_profile == 1) {
					$out .= '<p>
						<label for="age" '.($age_required_profile == 1?'class="required"':'').'>'.__("Age","vbegy").($age_required_profile == 1?'<span>*</span>':'').'</label>
						<input type="text" '.($age_required_profile == 1?'class="required-item"':'').' name="age" id="age" value="'.$age.'">
					</p>';
				}
				$gender_other = vpanel_options("gender_other");
				if ($sex_profile == 1) {
					$out .= '<p>
						<label '.($sex_required_profile == 1?'class="required"':'').'>'.__("Gender","vbegy").($sex_required_profile == 1?'<span>*</span>':'').'</label>
						<input id="sex_male" name="sex" type="radio" value="1"'.($sex == "male" || $sex == "1"?' checked="checked"':' checked="checked"').'>
						<label for="sex_male">'.__("Male","vbegy").'</label>
						<input id="sex_female" name="sex" type="radio" value="2"'.($sex == "female" || $sex == "2"?' checked="checked"':'').'>
						<label for="sex_female">'.__("Female","vbegy").'</label>';
						if ($gender_other == 1) {
							$out .= '<input id="sex_other" name="sex" type="radio" value="3"'.($sex == "other" || $sex == "3"?' checked="checked"':'').'>
							<label for="sex_other">'.__("Other","vbegy").'</label>';
						}
					$out .= '</p>';
				}
			$out .= '</div>
			<div class="form-style form-style-2 form-style-3">';
				$profile_picture_profile = vpanel_options("profile_picture_profile");
				$profile_picture_required_profile = vpanel_options("profile_picture_required_profile");
				if ($profile_picture_profile == 1) {
					if ($you_avatar) {
						$out .= "<div class='user-profile-img edit-profile-img'>".askme_user_avatar($you_avatar,79,79,$user_info->ID,$user_info->display_name)."</div>";
					}
					
					$out .= '
						<label '.($profile_picture_required_profile == 1?'class="required"':'').' for="you_avatar">'.__("Profile Picture","vbegy").($profile_picture_required_profile == 1?'<span>*</span>':'').'</label>
						<div class="fileinputs">
							<input type="file" name="you_avatar" id="you_avatar" value="'.$you_avatar.'">
							<div class="fakefile">
								<button type="button" class="small margin_0">'.__("Select file","vbegy").'</button>
								<span><i class="icon-arrow-up"></i>'.__("Browse","vbegy").'</span>
							</div>
						</div>
					<div class="clearfix"></div>
					<p></p>';
				}
				
				$out .= '<p>
					<label for="description">'.__("About Yourself","vbegy").'</label>
					<textarea name="description" id="description" cols="58" rows="8">'.$user_info->description.'</textarea>
				</p>
			</div>
			<div class="form-inputs clearfix">';
				if ($url_profile == 1) {
					$out .= '<p>
						<label '.($url_required_profile == 1?'class="required"':'').'>'.__("Website","vbegy").($url_required_profile == 1?'<span>*</span>':'').'</label>
						<input name="url" id="url" type="text" value="'.$url.'">
					</p>';
				}
				$out .= '<p>
					<label for="facebook">'.__("Facebook","vbegy").'</label>
					<input type="text" name="facebook" id="facebook" value="'.$facebook.'">
				</p>
				<p>
					<label for="twitter">'.__("Twitter","vbegy").'</label>
					<input type="text" name="twitter" id="twitter" value="'.$twitter.'">
				</p>
				<p>
					<label for="youtube">'.__("Youtube","vbegy").'</label>
					<input type="text" name="youtube" id="youtube" value="'.$youtube.'">
				</p>
				<p>
					<label for="linkedin">'.__("Linkedin","vbegy").'</label>
					<input type="text" name="linkedin" id="linkedin" value="'.$linkedin.'">
				</p>
				<p>
					<label for="instagram">'.__("Instagram","vbegy").'</label>
					<input type="text" name="instagram" id="instagram" value="'.$instagram.'">
				</p>
				<p>
					<label for="pinterest">'.__("Pinterest","vbegy").'</label>
					<input type="text" name="pinterest" id="pinterest" value="'.$pinterest.'">
				</p>
			</div>
			
			<label for="show_point_favorite">
				<input type="checkbox" name="show_point_favorite" id="show_point_favorite" value="1" '.checked($show_point_favorite,1,false).'>
				'.__("Show your private pages for all the users?","vbegy").'
			</label>

			<label for="follow_email">
				<input type="checkbox" name="follow_email" id="follow_email" value="1" '.checked($follow_email,1,false).'>
				'.__("Follow-up email","vbegy").'
			</label>';
			
			$send_email_question_groups = vpanel_options("send_email_question_groups");
			if (isset($send_email_question_groups) && is_array($send_email_question_groups)) {
				foreach ($send_email_question_groups as $key => $value) {
					if ($value == 1) {
						$send_email_question_groups[$key] = $key;
					}else {
						unset($send_email_question_groups[$key]);
					}
				}
			}
			if (is_array($send_email_question_groups) && in_array($user_info->roles[0],$send_email_question_groups)) {
				$out .= '<label for="received_email">
					<input type="checkbox" name="received_email" id="received_email" value="1" '.checked($received_email,1,false).'>
					'.__("Received mail when user add a new question","vbegy").'
				</label>';
			}
			
			$active_message = vpanel_options("active_message");
			if ($active_message = 1) {
				$out .= '<label for="received_message">
					<input type="checkbox" name="received_message" id="received_message" value="1" '.checked($received_message,($received_message == ""?"":1),false).'>
					'.__("Received message from another users?","vbegy").'
				</label>';
			}
			
			$out .= '<p class="form-submit">
				<input type="hidden" name="user_action" value="edit_profile">
				<input type="hidden" name="action" value="update">
				<input type="hidden" name="admin_bar_front" value="1">
				<input type="hidden" name="user_id" id="user_id" value="'.$user_info->ID.'">
				<input type="hidden" name="user_login" id="user_login" value="'.$user_info->user_login.'">
				<input type="submit" value="'.__("Save","vbegy").'" class="button color small login-submit submit">
			</p>
		
		</form>';
	}
	return $out;
}
/* ask_sanitize_user */ 
function ask_sanitize_user ($username, $raw_username, $strict) {
	if (!$strict) {
		return $username;
	}
	return sanitize_user(stripslashes($raw_username),false);
}
add_filter ('sanitize_user', 'ask_sanitize_user', 10, 3);
/* Get logout url */
function askme_get_logout() {
	$after_logout = vpanel_options("after_logout");
	$after_logout_link = vpanel_options("after_logout_link");
	$protocol = is_ssl() ? 'https' : 'http';
	if ($after_logout == "same_page") {
		$redirect_to = $protocol.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	}else if ($after_logout == "custom_link" && $after_logout_link != "") {
		$redirect_to = esc_url($after_logout_link);
	}else {
		$redirect_to = esc_url(home_url('/'));
	}
	$url = esc_url(wp_logout_url(wp_unslash($redirect_to)));
	return apply_filters('askme_filter_get_logout',$url);
}
/* Profile logout */
add_action('askme_action_get_logout','askme_action_get_logout');
if (!function_exists('askme_action_get_logout')) :
	function askme_action_get_logout() {
		echo askme_get_logout();
	}
endif;
/* Stop sent WordPress mail */
add_action('init','askme_send_new_user_notifications');
function askme_send_new_user_notifications() {
	remove_action('register_new_user','wp_send_new_user_notifications');
}?>