<?php
/**
 * The "Announce" template to show post's content
 *
 * Used in the widget Recent News.
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */
 
$widget_args = get_query_var('trx_addons_args_recent_news');
$style = $widget_args['style'];
$number = min(8, $widget_args['number']);
$count = min(8, $widget_args['count']);
$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$animation = apply_filters('trx_addons_blog_animation', '');
$grid = array(
	array('big'),
	array('medium', 'medium'),
	array('big', 'medium', 'medium'),
	array('big', 'medium', 'medium', 'medium'),
	array('big', 'medium', 'medium', 'medium', 'medium'),
	array('medium', 'medium', 'medium', 'medium', 'medium', 'medium'),
	array('medium', 'medium', 'medium', 'medium', 'medium', 'medium', 'medium'),
	array('medium', 'medium', 'medium', 'medium', 'medium', 'medium', 'medium', 'medium')
);
$thumb_size = $grid[$count-$number >= 8 ? 8 : ($count-1)%8][($number-1)%8];
?><article 
	<?php post_class( 'post_item post_layout_'.esc_attr($style)
					.' post_format_'.esc_attr($post_format)
					.' post_size_'.esc_attr($thumb_size)
					); ?>
	<?php echo (!empty($animation) ? ' data-animation="'.esc_attr($animation).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}
	
	trx_addons_get_template_part('templates/tpl.featured.php',
								'trx_addons_args_featured',
								apply_filters('trx_addons_filter_args_featured', array(
										'thumb_bg' => true,
										'hover' => false,
										'thumb_size' => trx_addons_get_thumb_size('big')
										),
										'recent_news-announce')
								);
	

	?>
    <div class="post_info">
        <div class="post_info_container">
            <h5 class="post_title entry-title"><a href="<?php the_permalink();?>" rel="bookmark"><?php echo get_the_title()?></a></h5>
            <div class="post_meta_container">
                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="post_author"><?php esc_html_e('By ', 'asia-garden'); ?><?php echo get_the_author() ?></a><?php
                trx_addons_sc_show_post_meta('recent_news-announce', apply_filters('trx_addons_filter_show_post_meta', array(

                        'components' => 'counters',
							'counters' => 'comments',
							'seo' => false
							), 'recent_news-announce')
						);	
			?>
			</div>
			<div class="recent_news_button">
				<a  class="sc_button" href="<?php the_permalink();?>"><?php esc_html_e('Read more', 'asia-garden'); ?></a>
			</div>
		</div>
	</div>
</article>