<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.22
 */

if (!defined("ASIA_GARDEN_THEME_FREE")) define("ASIA_GARDEN_THEME_FREE", false);

// Theme storage
$ASIA_GARDEN_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins' => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'					=> esc_html__('ThemeREX Addons', 'asia-garden'),
			
			// Recommended (supported) plugins
			// If plugin not need - comment (or remove) it
			
			
			
			'woocommerce'					=> esc_html__('WooCommerce', 'asia-garden'),
			'yith-woocommerce-wishlist'					=> esc_html__('YITH WooCommerce Wishlist', 'asia-garden'),
			'yith-woocommerce-compare'					=> esc_html__('YITH WooCommerce Compare', 'asia-garden')

		),

		// List of plugins for PREMIUM version only
		//-----------------------------------------------------
		ASIA_GARDEN_THEME_FREE ? array() : array(

			// Recommended (supported) plugins
			// If plugin not need - comment (or remove) it
			
			'booked'						=> esc_html__('Booked Appointments', 'asia-garden'),
			
			
			'js_composer'					=> esc_html__('WPBakery Page Builder', 'asia-garden'),

			
			
			'essential-grid'				=> esc_html__('Essential Grid', 'asia-garden'),
			'mailchimp-for-wp'				=> esc_html__('MailChimp for WP', 'asia-garden'),
			
			'revslider'						=> esc_html__('Revolution Slider', 'asia-garden'),
            'contact-form-7'				=> esc_html__('Contact form 7', 'asia-garden'),
            'elegro-payment'				=> esc_html__('Elegro payment', 'asia-garden'),
            'wp-gdpr-compliance'			=> esc_html__('Cookie Information', 'asia-garden'),
            'trx_updater'				    => esc_html__('TRX Updater', 'asia-garden')

			
			
		)
	),
	
	// Theme-specific URLs (will be escaped in place of the output)
    'theme_pro_key'		=> 'env-themerex',
	'theme_demo_url' => 'http://asia-garden.themerex.net',
	'theme_doc_url' => 'http://asia-garden.themerex.net/doc/',
	'theme_support_url' => 'https://themerex.net/support',
	'theme_download_url' => 'https://themeforest.net/item/asia-garden-asian-food-restaurant/20554743'
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('asia_garden_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'asia_garden_customizer_theme_setup1', 1 );
	function asia_garden_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		asia_garden_storage_set('settings', array(
			
			'duplicate_options'		=> 'child',		// none  - use separate options for template and child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes
			
			'custmize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame
		
			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts
		
			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'
			
			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:

													// internal - internal popup with plugin's or theme's icons list (fast)
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'allow_theme_layouts'	=> false		// Include theme's default headers and footers to the list after custom layouts
													// or leave in the list only custom layouts
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		asia_garden_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Signika',
				'family' => 'sans-serif',
				'styles' => '300,400,600,700'		// Parameter 'style' used only for the Google fonts
				),
			// Font-face packed with theme
			array(
				'name'   => 'GangofThree',
				'family' => ''
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		asia_garden_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		asia_garden_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.165px',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '0.95em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '6.25em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.63em',
				'margin-bottom'		=> '0.18em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '5.625em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1111em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.88em',
				'margin-bottom'		=> '0.29em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '5em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1515em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.82em',
				'margin-bottom'		=> '0.3em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '4.375em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3043em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.87em',
				'margin-bottom'		=> '0.26em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '3.75em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.35em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.97em',
				'margin-bottom'		=> '0.32em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '3.125em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.4706em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.12em',
				'margin-bottom'		=> '0.35em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'asia-garden'),
				'font-family'		=> '"GangofThree"',
				'font-size' 		=> '1.875em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '0.938em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '-0.1px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.65px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '13px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '-0.15px',
				'margin-top'		=> '0',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the main menu items', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '-0.1px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'asia-garden'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'asia-garden'),
				'font-family'		=> '"Signika",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '-0.1px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		asia_garden_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'asia-garden'),
							'description'	=> esc_html__( 'Colors of the main content area', 'asia-garden')
							),
			'alter'	=> array(
							'title'			=> esc_html__( 'Alter', 'asia-garden'),
							'description'	=> esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'asia-garden')
							),
			'extra'	=> array(
							'title'			=> esc_html__( 'Extra', 'asia-garden'),
							'description'	=> esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'asia-garden')
							),
			'inverse' => array(
							'title'			=> esc_html__( 'Inverse', 'asia-garden'),
							'description'	=> esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'asia-garden')
							),
			'input'	=> array(
							'title'			=> esc_html__( 'Input', 'asia-garden'),
							'description'	=> esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'asia-garden')
							),
			)
		);
		asia_garden_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__( 'Background color', 'asia-garden'),
							'description'	=> esc_html__( 'Background color of this block in the normal state', 'asia-garden')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__( 'Background hover', 'asia-garden'),
							'description'	=> esc_html__( 'Background color of this block in the hovered state', 'asia-garden')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__( 'Border color', 'asia-garden'),
							'description'	=> esc_html__( 'Border color of this block in the normal state', 'asia-garden')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__( 'Border hover', 'asia-garden'),
							'description'	=> esc_html__( 'Border color of this block in the hovered state', 'asia-garden')
							),
			'text'		=> array(
							'title'			=> esc_html__( 'Text', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the plain text inside this block', 'asia-garden')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__( 'Text dark', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'asia-garden')
							),
			'text_light'=> array(
							'title'			=> esc_html__( 'Text light', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'asia-garden')
							),
			'text_link'	=> array(
							'title'			=> esc_html__( 'Link', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the links inside this block', 'asia-garden')
							),
			'text_hover'=> array(
							'title'			=> esc_html__( 'Link hover', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the hovered state of links inside this block', 'asia-garden')
							),
			'text_link2'=> array(
							'title'			=> esc_html__( 'Link 2', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the accented texts (areas) inside this block', 'asia-garden')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__( 'Link 2 hover', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'asia-garden')
							),
			'text_link3'=> array(
							'title'			=> esc_html__( 'Link 3', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the other accented texts (buttons) inside this block', 'asia-garden')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__( 'Link 3 hover', 'asia-garden'),
							'description'	=> esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'asia-garden')
							)
			)
		);
		asia_garden_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'asia-garden'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff', //
					'bd_color'			=> '#e8e8e8', // 
		
					// Text and links colors
					'text'				=> '#747474', //
					'text_light'		=> '#747474', //
					'text_dark'			=> '#22201d', //
					'text_link'			=> '#ee322a', //
					'text_hover'		=> '#22201d', //
					'text_link2'		=> '#ee322a', //
					'text_hover2'		=> '#ee322a',
					'text_link3'		=> '#ee322a', //
					'text_hover3'		=> '#ffffff', //
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#22211f', //
					'alter_bg_hover'	=> '#383735', //
					'alter_bd_color'	=> '#e5e5e5', //
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#333333',
					'alter_light'		=> '#b7b7b7',
					'alter_dark'		=> '#1d1d1d',
					'alter_link'		=> '#ee322a',
					'alter_hover'		=> '#22201d',
					'alter_link2'		=> '#ee322a',
					'alter_hover2'		=> '#ee322a',
					'alter_link3'		=> '#ee322a',
					'alter_hover3'		=> '#ffffff',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#ee322a', //
					'extra_bg_hover'	=> '#eae9e9', //
					'extra_bd_color'	=> '#313131', //
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#bfbfbf',
					'extra_light'		=> '#e9e9e9',
					'extra_dark'		=> '#ffffff', //
					'extra_link'		=> '#ffffff', //
					'extra_hover'		=> '#22201d', //
					'extra_link2'		=> '#22201d', //
					'extra_hover2'		=> '#ffffff', //
					'extra_link3'		=> '#ffffff', //
					'extra_hover3'		=> '#ee322a', //
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#22201d', //
					'input_bg_hover'	=> '#22201d', //
					'input_bd_color'	=> '#22201d', //
					'input_bd_hover'	=> '#22201d', //
					'input_text'		=> '#ffffff', //
					'input_light'		=> '#d0d0d0',
					'input_dark'		=> '#1d1d1d',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#ffffff', //
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#ffffff', //
					'inverse_link'		=> '#ffffff', //
					'inverse_hover'		=> '#ffffff' //
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'asia-garden'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#22211f', //
					'bd_color'			=> '#393736', //
		
					// Text and links colors
					'text'				=> '#747474', //
					'text_light'		=> '#747474', //
					'text_dark'			=> '#ffffff', //
					'text_link'			=> '#ee322a', //
					'text_hover'		=> '#ffffff', //
					'text_link2'		=> '#ffffff', //
					'text_hover2'		=> '#ee322a',
					'text_link3'		=> '#ee322a', //
					'text_hover3'		=> '#22201d', //

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#22211f', //
					'alter_bg_hover'	=> '#383735', //
					'alter_bd_color'	=> '#313131',
					'alter_bd_hover'	=> '#3d3d3d',
					'alter_text'		=> '#a6a6a6',
					'alter_light'		=> '#5f5f5f',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#ee322a',
					'alter_hover'		=> '#ee322a',
					'alter_link2'		=> '#ee322a',
					'alter_hover2'		=> '#ee322a',
					'alter_link3'		=> '#ee322a',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#ffffff', //
					'extra_bg_hover'	=> '#eae9e9', //
					'extra_bd_color'	=> '#313131', //
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#a6a6a6',
					'extra_light'		=> '#e5e4e4', //
					'extra_dark'		=> '#22201d', //
					'extra_link'		=> '#22201d', //
					'extra_hover'		=> '#ffffff', //
					'extra_link2'		=> '#ffffff', //
					'extra_hover2'		=> '#22201d', //
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#ee322a',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#ffffff', //
					'input_bg_hover'	=> '#ffffff', //
					'input_bd_color'	=> '#ffffff', //
					'input_bd_hover'	=> '#ffffff', //
					'input_text'		=> '#22201d', //
					'input_light'		=> '#5f5f5f',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#ffffff', //
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#ffffff', //
					'inverse_link'		=> '#ffffff', //
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
		
		// Simple schemes substitution
		asia_garden_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));
	}
}

			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('asia_garden_customizer_add_theme_colors')) {
	function asia_garden_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = asia_garden_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_02']  = asia_garden_hex2rgba( $colors['bg_color'], 0.2 );
			$colors['bg_color_07']  = asia_garden_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = asia_garden_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['bg_color_09']  = asia_garden_hex2rgba( $colors['bg_color'], 0.9 );
			$colors['alter_bg_color_07']  = asia_garden_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = asia_garden_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = asia_garden_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = asia_garden_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['extra_bg_color_07']  = asia_garden_hex2rgba( $colors['extra_bg_color'], 0.7 );
			$colors['extra_bg_hover_04']  = asia_garden_hex2rgba( $colors['extra_bg_hover'], 0.4 );
			$colors['extra_bd_color_003']  = asia_garden_hex2rgba( $colors['extra_bd_color'], 0.03 );
			$colors['extra_bd_color_07']  = asia_garden_hex2rgba( $colors['extra_bd_color'], 0.7 );
			$colors['extra_link_05']  = asia_garden_hex2rgba( $colors['extra_link'], 0.5 );
			$colors['text_dark_05']  = asia_garden_hex2rgba( $colors['text_dark'], 0.5 );
			$colors['text_dark_06']  = asia_garden_hex2rgba( $colors['text_dark'], 0.6 );
			$colors['text_dark_07']  = asia_garden_hex2rgba( $colors['text_dark'], 0.7 );
			$colors['text_link_015']  = asia_garden_hex2rgba( $colors['text_link'], 0.15 );
			$colors['text_link_02']  = asia_garden_hex2rgba( $colors['text_link'], 0.2 );
			$colors['text_link_03']  = asia_garden_hex2rgba( $colors['text_link'], 0.3 );
			$colors['text_link_07']  = asia_garden_hex2rgba( $colors['text_link'], 0.7 );
			$colors['text_link_08']  = asia_garden_hex2rgba( $colors['text_link'], 0.8 );
			$colors['inverse_text_07']  = asia_garden_hex2rgba( $colors['inverse_text'], 0.7 );
			$colors['text_link_blend'] = asia_garden_hsb2hex(asia_garden_hex2hsb( $colors['text_link'], 2, -5, 5 ));
			$colors['alter_link_blend'] = asia_garden_hsb2hex(asia_garden_hex2hsb( $colors['alter_link'], 2, -5, 5 ));
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['bg_color_09'] = '{{ data.bg_color_09 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['extra_bg_color_07'] = '{{ data.extra_bg_color_07 }}';
			$colors['extra_bg_hover_04'] = '{{ data.extra_bg_hover_04 }}';
			$colors['extra_bd_color_003'] = '{{ data.extra_bd_color_003 }}';
			$colors['extra_bd_color_07'] = '{{ data.extra_bd_color_07 }}';
			$colors['extra_link_05'] = '{{ data.extra_link_05 }}';
			$colors['text_dark_05'] = '{{ data.text_dark_05 }}';
			$colors['text_dark_06'] = '{{ data.text_dark_06 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_link_015'] = '{{ data.text_link_015 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_03'] = '{{ data.text_link_03 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
			$colors['text_link_08'] = '{{ data.text_link_08 }}';
			$colors['inverse_text_07'] = '{{ data.inverse_text_07 }}';
			$colors['text_link_blend'] = '{{ data.text_link_blend }}';
			$colors['alter_link_blend'] = '{{ data.alter_link_blend }}';
		}
		return $colors;
	}
}


			
// Additional theme-specific fonts rules
// Attention! Don't forget setup fonts rules also in the theme.customizer.color-scheme.js
if (!function_exists('asia_garden_customizer_add_theme_fonts')) {
	function asia_garden_customizer_add_theme_fonts($fonts) {
		$rez = array();	
		foreach ($fonts as $tag => $font) {
			
			if (substr($font['font-family'], 0, 2) != '{{') {
				$rez[$tag.'_font-family'] 		= !empty($font['font-family']) && !asia_garden_is_inherit($font['font-family'])
														? 'font-family:' . trim($font['font-family']) . ';' 
														: '';
				$rez[$tag.'_font-size'] 		= !empty($font['font-size']) && !asia_garden_is_inherit($font['font-size'])
														? 'font-size:' . asia_garden_prepare_css_value($font['font-size']) . ";"
														: '';
				$rez[$tag.'_line-height'] 		= !empty($font['line-height']) && !asia_garden_is_inherit($font['line-height'])
														? 'line-height:' . trim($font['line-height']) . ";"
														: '';
				$rez[$tag.'_font-weight'] 		= !empty($font['font-weight']) && !asia_garden_is_inherit($font['font-weight'])
														? 'font-weight:' . trim($font['font-weight']) . ";"
														: '';
				$rez[$tag.'_font-style'] 		= !empty($font['font-style']) && !asia_garden_is_inherit($font['font-style'])
														? 'font-style:' . trim($font['font-style']) . ";"
														: '';
				$rez[$tag.'_text-decoration'] 	= !empty($font['text-decoration']) && !asia_garden_is_inherit($font['text-decoration'])
														? 'text-decoration:' . trim($font['text-decoration']) . ";"
														: '';
				$rez[$tag.'_text-transform'] 	= !empty($font['text-transform']) && !asia_garden_is_inherit($font['text-transform'])
														? 'text-transform:' . trim($font['text-transform']) . ";"
														: '';
				$rez[$tag.'_letter-spacing'] 	= !empty($font['letter-spacing']) && !asia_garden_is_inherit($font['letter-spacing'])
														? 'letter-spacing:' . trim($font['letter-spacing']) . ";"
														: '';
				$rez[$tag.'_margin-top'] 		= !empty($font['margin-top']) && !asia_garden_is_inherit($font['margin-top'])
														? 'margin-top:' . asia_garden_prepare_css_value($font['margin-top']) . ";"
														: '';
				$rez[$tag.'_margin-bottom'] 	= !empty($font['margin-bottom']) && !asia_garden_is_inherit($font['margin-bottom'])
														? 'margin-bottom:' . asia_garden_prepare_css_value($font['margin-bottom']) . ";"
														: '';
			} else {
				$rez[$tag.'_font-family']		= '{{ data["'.$tag.'_font-family"] }}';
				$rez[$tag.'_font-size']			= '{{ data["'.$tag.'_font-size"] }}';
				$rez[$tag.'_line-height']		= '{{ data["'.$tag.'_line-height"] }}';
				$rez[$tag.'_font-weight']		= '{{ data["'.$tag.'_font-weight"] }}';
				$rez[$tag.'_font-style']		= '{{ data["'.$tag.'_font-style"] }}';
				$rez[$tag.'_text-decoration']	= '{{ data["'.$tag.'_text-decoration"] }}';
				$rez[$tag.'_text-transform']	= '{{ data["'.$tag.'_text-transform"] }}';
				$rez[$tag.'_letter-spacing']	= '{{ data["'.$tag.'_letter-spacing"] }}';
				$rez[$tag.'_margin-top']		= '{{ data["'.$tag.'_margin-top"] }}';
				$rez[$tag.'_margin-bottom']		= '{{ data["'.$tag.'_margin-bottom"] }}';
			}
		}
		return $rez;
	}
}




//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------

if ( !function_exists('asia_garden_customizer_theme_setup') ) {
	add_action( 'after_setup_theme', 'asia_garden_customizer_theme_setup' );
	function asia_garden_customizer_theme_setup() {

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('asia_garden_filter_add_thumb_sizes', array(
			'asia_garden-thumb-huge'		=> array(1170, 605, true),
			'asia_garden-thumb-big' 		=> array( 812, 420, true),
			'asia_garden-thumb-med' 		=> array( 370, 191, true),
			'asia_garden-thumb-tiny' 		=> array(  90,  90, true),
			'asia_garden-thumb-avatar' 		=> array( 356, 356, true),
			'asia_garden-thumb-dishes' 		=> array( 356, 296, true),
			'asia_garden-thumb-masonry-big' => array( 812,   0, false),		// Only downscale, not crop
			'asia_garden-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = asia_garden_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'asia_garden_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}

	}
}

if ( !function_exists('asia_garden_customizer_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'asia_garden_customizer_image_sizes' );
	function asia_garden_customizer_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('asia_garden_filter_add_thumb_sizes', array(
			'asia_garden-thumb-huge'		=> esc_html__( 'Huge image', 'asia-garden' ),
			'asia_garden-thumb-big'			=> esc_html__( 'Large image', 'asia-garden' ),
			'asia_garden-thumb-med'			=> esc_html__( 'Medium image', 'asia-garden' ),
			'asia_garden-thumb-tiny'		=> esc_html__( 'Small square avatar', 'asia-garden' ),
			'asia_garden-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'asia-garden' ),
			'asia_garden-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'asia-garden' ),
			)
		);
		$mult = asia_garden_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'asia-garden' );
		}
		return $sizes;
	}
}

// Remove some thumb-sizes from the ThemeREX Addons list
if ( !function_exists( 'asia_garden_customizer_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'asia_garden_customizer_trx_addons_add_thumb_sizes');
	function asia_garden_customizer_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// and replace removed styles with theme-specific thumb size
if ( !function_exists( 'asia_garden_customizer_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'asia_garden_customizer_trx_addons_get_thumb_size');
	function asia_garden_customizer_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-avatar',
							'trx_addons-thumb-avatar-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'asia_garden-thumb-huge',
							'asia_garden-thumb-huge-@retina',
							'asia_garden-thumb-big',
							'asia_garden-thumb-big-@retina',
							'asia_garden-thumb-med',
							'asia_garden-thumb-med-@retina',
							'asia_garden-thumb-tiny',
							'asia_garden-thumb-tiny-@retina',
							'asia_garden-thumb-dishes',
							'asia_garden-thumb-dishes-@retina',
							'asia_garden-thumb-avatar',
							'asia_garden-thumb-avatar-@retina',
							'asia_garden-thumb-masonry-big',
							'asia_garden-thumb-masonry-big-@retina',
							'asia_garden-thumb-masonry',
							'asia_garden-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'asia_garden_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'asia_garden_importer_set_options', 9 );
	function asia_garden_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
            $options['demo_url'] = esc_url(asia_garden_get_protocol() . '://demofiles.themerex.net/asia-garden/');
			// Required plugins
			$options['required_plugins'] = array_keys(asia_garden_storage_get('required_plugins'));
			// Default demo
			$options['files']['default']['title'] = esc_html__('Asia Garden Demo', 'asia-garden');
			$options['files']['default']['domain_dev'] = esc_url('http://asia-garden.dev');		// Developers domain
			$options['files']['default']['domain_demo']= esc_url('http://asia-garden.themerex.net');		// Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
			
			
			
		}
		return $options;
	}
}




// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('asia_garden_create_theme_options')) {

	function asia_garden_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __( '<b>Attention!</b> Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'asia-garden');

		asia_garden_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'asia-garden'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'asia-garden'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images below are not specified?', 'asia-garden') ),
				"std" => 1,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'asia-garden') ),
				"class" => "asia_garden_column-1_2 asia_garden_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'asia-garden') ),
				"class" => "asia_garden_column-1_2",
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'asia-garden') ),
				"class" => "asia_garden_column-1_2 asia_garden_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'asia-garden') ),
				"class" => "asia_garden_column-1_2",
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'asia-garden') ),
				"class" => "asia_garden_column-1_2 asia_garden_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'asia-garden') ),
				"class" => "asia_garden_column-1_2",
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "image"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'asia-garden'),
				"desc" => wp_kses_data( __('Settings for the entire site', 'asia-garden') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'asia-garden'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'asia-garden'),
				"desc" => wp_kses_data( __('Select width of the body content', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'asia-garden')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'asia-garden'),
					'wide'		=> esc_html__('Wide',		'asia-garden'),
					'fullscreen'=> esc_html__('Fullscreen',	'asia-garden')
				),
				"type" => "select"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'asia-garden') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'asia-garden')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'asia-garden'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'asia-garden')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'asia-garden'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'asia-garden'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'asia-garden'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'asia-garden'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'asia-garden'),
				"desc" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'asia-garden'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'asia-garden'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'asia-garden'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'asia-garden'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'asia-garden')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'asia-garden'),
				"desc" => '',
				"hidden" => true,
				"type" => "info",
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'asia-garden'),
				"desc" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'asia-garden'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'asia-garden') ),
				"std" => 0,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),

            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'asia-garden'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'asia-garden') ),
                "std"   => wp_kses_post( __( 'I agree that my submitted data is being collected and stored.', 'asia-garden') ),
                "type"  => "text"
            ),
		
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'asia-garden'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'asia-garden'),
				"desc" => '',
				"type" => "info"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'asia-garden'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'asia-garden'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => 'default',
				"options" => array(),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'asia-garden'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => 0,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'asia-garden'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => 1,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_logo_info' => array(
				"title" => esc_html__('Header logo info', 'asia-garden'),
				"desc" => wp_kses_data( __('Here you can add some info in logo.', 'asia-garden') ),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"type" => "info"
				),
			'header_logo_left_text' => array(
				"title" => esc_html__('Left description', 'asia-garden'),
				"desc" => wp_kses_data( __('Left description', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => '',
				"type" => "text"
				),
			'header_logo_right_text' => array(
				"title" => esc_html__('Right description', 'asia-garden'),
				"desc" => wp_kses_data( __('Right description', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => '',
				"type" => "text"
				),
			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'asia-garden'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'asia-garden') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'asia-garden'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'asia-garden') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'asia-garden'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"dependency" => array(
					'header_style' => array('header-default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => asia_garden_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'asia-garden'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'asia-garden') ),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'asia-garden'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'asia-garden')
				),
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'asia-garden'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'asia-garden') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'asia-garden'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'asia-garden') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'asia-garden'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'asia-garden') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'asia-garden'),
				"desc" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'asia-garden'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'asia-garden') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => 0,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
				),
			'title_image' => array(
				"title" => esc_html__('Image for title', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload image for title (Only for default header)', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => '',
				"type" => "image"
				),

		
			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'asia-garden'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number in the site footer', 'asia-garden') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'asia-garden'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"std" => 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'asia-garden'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'asia-garden'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => asia_garden_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'asia-garden'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'asia-garden'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'asia-garden') ),
				'refresh' => false,
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'asia-garden') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'asia-garden') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "image"
				),
			'footer_logo_left_text' => array(
				"title" => esc_html__('Left description', 'asia-garden'),
				"desc" => wp_kses_data( __('Left description', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "text"
				),
			'footer_logo_right_text' => array(
				"title" => esc_html__('Right description', 'asia-garden'),
				"desc" => wp_kses_data( __('Right description', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "text"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'asia-garden'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'asia-garden') ),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'asia-garden'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'asia-garden') ),
				"std" => esc_html__('ThemeREX &copy; {Y}. All rights reserved. Terms of use and Privacy Policy', 'asia-garden'),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			'footer_image' => array(
				"title" => esc_html__('Image in footer', 'asia-garden'),
				"desc" => wp_kses_data( __('Select or upload image for title', 'asia-garden') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'asia-garden')
				),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => '',
				"type" => "image"
				),
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'asia-garden'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'asia-garden') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'asia-garden'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'asia-garden') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'asia-garden'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'asia-garden'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'asia-garden'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'asia-garden'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'asia-garden') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'asia-garden'),
						'fullpost'	=> esc_html__('Full post',	'asia-garden')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'asia-garden'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'asia-garden') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 60,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'asia-garden'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'asia-garden') ),
					"std" => 2,
					"options" => asia_garden_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'asia-garden'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'asia-garden'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'asia-garden'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'asia-garden'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"std" => "pages",
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'asia-garden'),
						'links'	=> esc_html__("Older/Newest", 'asia-garden'),
						'more'	=> esc_html__("Load more", 'asia-garden'),
						'infinite' => esc_html__("Infinite scroll", 'asia-garden')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'asia-garden'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'asia-garden'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'asia-garden'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'asia-garden') ),
					"override" => array(
						'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__('Widgets', 'asia-garden')
					),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'asia-garden'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'asia-garden') ),
					"override" => array(
						'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__('Widgets', 'asia-garden')
					),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'asia-garden'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'asia-garden') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'asia-garden'),
					"desc" => '',
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'asia-garden'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'asia-garden') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'asia-garden'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'asia-garden') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'asia-garden'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'asia-garden') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'asia-garden'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'asia-garden') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'asia-garden'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'asia-garden'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'asia-garden') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'asia-garden'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'asia-garden') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'asia-garden'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'asia-garden') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'asia-garden'),
						'columns' => esc_html__('Mini-cards',	'asia-garden')
					),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'asia-garden'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => "none",
					"options" => array(),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'asia-garden'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page.", 'asia-garden') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=1|counters=1|author=0|share=0|edit=1',
					"options" => array(
						'categories' => esc_html__('Categories', 'asia-garden'),
						'date'		 => esc_html__('Post date', 'asia-garden'),
						'author'	 => esc_html__('Post author', 'asia-garden'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'asia-garden'),
						'share'		 => esc_html__('Share links', 'asia-garden'),
						'edit'		 => esc_html__('Edit link', 'asia-garden')
					),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checklist"
				),
				'counters' => array(
					"title" => esc_html__('Views, Likes and Comments', 'asia-garden'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'asia-garden') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=1|likes=1|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'asia-garden'),
						'likes' => esc_html__('Likes', 'asia-garden'),
						'comments' => esc_html__('Comments', 'asia-garden')
					),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'asia-garden'),
					"desc" => wp_kses_data( __('Settings of the single post', 'asia-garden') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'asia-garden'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'asia-garden') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'asia-garden'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'asia-garden') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'asia-garden'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'asia-garden') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'asia-garden'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'asia-garden') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'asia-garden'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'asia-garden') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'asia-garden'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'asia-garden') ),
					"override" => array(
						'mode' => 'none',
						'section' => esc_html__('Content', 'asia-garden')
					),
					"hidden" => true,
					"std" => 0,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'asia-garden'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts showed.', 'asia-garden') ),
					"dependency" => array(
						'mode' => 'none',
						'show_related_posts' => array('1')
					),
					"std" => 2,
					"hidden" => true,
					"options" => asia_garden_get_list_range(1,9),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'asia-garden'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'asia-garden') ),
					"dependency" => array(
						'mode' => 'none',
						'show_related_posts' => array('1')
					),
					"std" => 2,
					"hidden" => true,
					"options" => asia_garden_get_list_range(1,2),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'asia-garden'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'asia-garden') ),
					"dependency" => array(
						'mode' => 'none',
						'show_related_posts' => array('1')
					),
					"std" => 2,
					"hidden" => true,
					"options" => asia_garden_get_list_styles(2,2),
					"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'asia-garden'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'asia-garden'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'asia-garden') ),
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'asia-garden'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'asia-garden')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'asia-garden'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'asia-garden')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'asia-garden'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'asia-garden')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'asia-garden'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'asia-garden')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'asia-garden'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'asia-garden')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'asia-garden'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'asia-garden') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'asia-garden'),
				"desc" => '',
				"std" => '$asia_garden_get_scheme_storage',
				"refresh" => false,
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'asia-garden'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'asia-garden') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'asia-garden')
				),
				"hidden" => true,
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'asia-garden'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'asia-garden') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'asia-garden')
				),
				"hidden" => true,
				"std" => '',
				"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'asia-garden'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'asia-garden'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'asia-garden') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'asia-garden') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'asia-garden'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'asia-garden') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'asia-garden') ),
				"class" => "asia_garden_column-1_3 asia_garden_new_row",
				"refresh" => false,
				"std" => '$asia_garden_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=asia_garden_get_theme_setting('max_load_fonts'); $i++) {
			if (asia_garden_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					"title" => esc_html(sprintf(__('Font %s', 'asia-garden'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'asia-garden'),
				"desc" => '',
				"class" => "asia_garden_column-1_3 asia_garden_new_row",
				"refresh" => false,
				"std" => '$asia_garden_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'asia-garden'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'asia-garden') )
							: '',
				"class" => "asia_garden_column-1_3",
				"refresh" => false,
				"std" => '$asia_garden_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'asia-garden'),
					'serif' => esc_html__('serif', 'asia-garden'),
					'sans-serif' => esc_html__('sans-serif', 'asia-garden'),
					'monospace' => esc_html__('monospace', 'asia-garden'),
					'cursive' => esc_html__('cursive', 'asia-garden'),
					'fantasy' => esc_html__('fantasy', 'asia-garden')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'asia-garden'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'asia-garden') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'asia-garden') )
							: '',
				"class" => "asia_garden_column-1_3",
				"refresh" => false,
				"std" => '$asia_garden_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = asia_garden_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(__('%s settings', 'asia-garden'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'asia-garden'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'asia-garden'),
						'100' => esc_html__('100 (Light)', 'asia-garden'), 
						'200' => esc_html__('200 (Light)', 'asia-garden'), 
						'300' => esc_html__('300 (Thin)',  'asia-garden'),
						'400' => esc_html__('400 (Normal)', 'asia-garden'),
						'500' => esc_html__('500 (Semibold)', 'asia-garden'),
						'600' => esc_html__('600 (Semibold)', 'asia-garden'),
						'700' => esc_html__('700 (Bold)', 'asia-garden'),
						'800' => esc_html__('800 (Black)', 'asia-garden'),
						'900' => esc_html__('900 (Black)', 'asia-garden')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'asia-garden'),
						'normal' => esc_html__('Normal', 'asia-garden'), 
						'italic' => esc_html__('Italic', 'asia-garden')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'asia-garden'),
						'none' => esc_html__('None', 'asia-garden'), 
						'underline' => esc_html__('Underline', 'asia-garden'),
						'overline' => esc_html__('Overline', 'asia-garden'),
						'line-through' => esc_html__('Line-through', 'asia-garden')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'asia-garden'),
						'none' => esc_html__('None', 'asia-garden'), 
						'uppercase' => esc_html__('Uppercase', 'asia-garden'),
						'lowercase' => esc_html__('Lowercase', 'asia-garden'),
						'capitalize' => esc_html__('Capitalize', 'asia-garden')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "asia_garden_column-1_5",
					"refresh" => false,
					"std" => '$asia_garden_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		asia_garden_storage_merge_array('options', '', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			asia_garden_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'asia-garden'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'asia-garden') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'asia-garden')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}
	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('asia_garden_options_get_list_cpt_options')) {
	function asia_garden_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Header style', 'asia-garden'),
						"desc" => wp_kses_data( sprintf(__('Select style to display the site header on the %s pages', 'asia-garden'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'asia-garden'),
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'asia-garden'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "switch"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'asia-garden'),
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'asia-garden'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'asia-garden'),
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'asia-garden'), $title) ),
						"refresh" => false,
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'asia-garden'),
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'asia-garden'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'asia-garden'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'asia-garden') ),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),
					"footer_scheme_{$cpt}" => array(
						"title" => esc_html__('Footer Color Scheme', 'asia-garden'),
						"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'asia-garden') ),
						"std" => 'dark',
						"options" => array(),
						"type" => "switch"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'asia-garden'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'asia-garden') ),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'asia-garden'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'asia-garden') ),
						"dependency" => array(
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => asia_garden_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwide', 'asia-garden'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'asia-garden') ),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'asia-garden'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'asia-garden') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'asia-garden'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'asia-garden') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'asia-garden'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'asia-garden') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'asia-garden'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'asia-garden') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ASIA_GARDEN_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('asia_garden_options_get_list_choises')) {
	add_filter('asia_garden_filter_options_get_list_choises', 'asia_garden_options_get_list_choises', 10, 2);
	function asia_garden_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = asia_garden_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = asia_garden_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, 'header_scheme')===0 
					|| strpos($id, 'menu_scheme')===0
					|| strpos($id, 'color_scheme')===0
					|| strpos($id, 'sidebar_scheme')===0
					|| strpos($id, 'footer_scheme')===0)
				$list = asia_garden_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = asia_garden_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = asia_garden_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = asia_garden_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = asia_garden_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = asia_garden_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = asia_garden_array_merge(array(0 => esc_html__('- Select category -', 'asia-garden')), asia_garden_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = asia_garden_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = asia_garden_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = asia_garden_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>