<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_post_id    = get_the_ID();
$asia_garden_post_date  = asia_garden_get_date();
$asia_garden_post_title = get_the_title();
$asia_garden_post_link  = get_permalink();
$asia_garden_post_author_id   = get_the_author_meta('ID');
$asia_garden_post_author_name = get_the_author_meta('display_name');
$asia_garden_post_author_url  = get_author_posts_url($asia_garden_post_author_id, '');

$asia_garden_args = get_query_var('asia_garden_args_widgets_posts');
$asia_garden_show_date = isset($asia_garden_args['show_date']) ? (int) $asia_garden_args['show_date'] : 1;
$asia_garden_show_image = isset($asia_garden_args['show_image']) ? (int) $asia_garden_args['show_image'] : 1;
$asia_garden_show_author = isset($asia_garden_args['show_author']) ? (int) $asia_garden_args['show_author'] : 1;
$asia_garden_show_counters = isset($asia_garden_args['show_counters']) ? (int) $asia_garden_args['show_counters'] : 1;
$asia_garden_show_categories = isset($asia_garden_args['show_categories']) ? (int) $asia_garden_args['show_categories'] : 1;

$asia_garden_output = asia_garden_storage_get('asia_garden_output_widgets_posts');

$asia_garden_post_counters_output = '';
if ( $asia_garden_show_counters ) {
	$asia_garden_post_counters_output = '<span class="post_info_item post_info_counters">'
								. asia_garden_get_post_counters('comments')
							. '</span>';
}


$asia_garden_output .= '<article class="post_item with_thumb">';

if ($asia_garden_show_image) {
	$asia_garden_post_thumb = get_the_post_thumbnail($asia_garden_post_id, asia_garden_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($asia_garden_post_thumb) $asia_garden_output .= '<div class="post_thumb">' . ($asia_garden_post_link ? '<a href="' . esc_url($asia_garden_post_link) . '">' : '') . ($asia_garden_post_thumb) . ($asia_garden_post_link ? '</a>' : '') . '</div>';
}

$asia_garden_output .= '<div class="post_content">'
			. ($asia_garden_show_categories 
					? '<div class="post_categories">'
						. asia_garden_get_post_categories()
						. $asia_garden_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($asia_garden_post_link ? '<a href="' . esc_url($asia_garden_post_link) . '">' : '') . ($asia_garden_post_title) . ($asia_garden_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('asia_garden_filter_get_post_info', 
								'<div class="post_info">'
									. ($asia_garden_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($asia_garden_post_link ? '<a href="' . esc_url($asia_garden_post_link) . '" class="post_info_date">' : '') 
											. esc_html($asia_garden_post_date) 
											. ($asia_garden_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($asia_garden_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'asia-garden') . ' ' 
											. ($asia_garden_post_link ? '<a href="' . esc_url($asia_garden_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($asia_garden_post_author_name) 
											. ($asia_garden_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$asia_garden_show_categories && $asia_garden_post_counters_output
										? $asia_garden_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
asia_garden_storage_set('asia_garden_output_widgets_posts', $asia_garden_output);
?>