<?php
/**
 * The template to display the Structured Data Snippets
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.30
 */

// Structured data snippets
if (asia_garden_is_on(asia_garden_get_theme_option('seo_snippets'))) {
	?><div class="structured_data_snippets">
		<meta itemprop="headline" content="<?php the_title_attribute(); ?>">
		<meta itemprop="datePublished" content="<?php echo esc_attr(get_the_date('Y-m-d')); ?>">
		<meta itemprop="dateModified" content="<?php echo esc_attr(get_the_modified_date('Y-m-d')); ?>">
		<div itemscope itemprop="publisher" itemtype="https://schema.org/Organization">
			<meta itemprop="name" content="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
			<meta itemprop="telephone" content="">
			<meta itemprop="address" content="">
			<?php
			$asia_garden_logo_image = asia_garden_get_retina_multiplier(2) > 1 
								? asia_garden_get_theme_option( 'logo_retina' )
								: asia_garden_get_theme_option( 'logo' );
			if (!empty($asia_garden_logo_image)) {
				?><meta itemprop="logo" itemtype="https://schema.org/logo" content="<?php echo esc_url($asia_garden_logo_image); ?>"><?php
			}
			?>
		</div>
	</div>
	<?php
}
?>