<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

// Header sidebar
$asia_garden_header_name = asia_garden_get_theme_option('header_widgets');
$asia_garden_header_present = !asia_garden_is_off($asia_garden_header_name) && is_active_sidebar($asia_garden_header_name);
if ($asia_garden_header_present) { 
	asia_garden_storage_set('current_sidebar', 'header');
	$asia_garden_header_wide = asia_garden_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($asia_garden_header_name) ) {
		dynamic_sidebar($asia_garden_header_name);
	}
	$asia_garden_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($asia_garden_widgets_output)) {
		$asia_garden_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $asia_garden_widgets_output);
		$asia_garden_need_columns = strpos($asia_garden_widgets_output, 'columns_wrap')===false;
		if ($asia_garden_need_columns) {
			$asia_garden_columns = max(0, (int) asia_garden_get_theme_option('header_columns'));
			if ($asia_garden_columns == 0) $asia_garden_columns = min(6, max(1, substr_count($asia_garden_widgets_output, '<aside ')));
			if ($asia_garden_columns > 1)
				$asia_garden_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($asia_garden_columns).' widget ', $asia_garden_widgets_output);
			else
				$asia_garden_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($asia_garden_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$asia_garden_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($asia_garden_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'asia_garden_action_before_sidebar' );
				asia_garden_show_layout($asia_garden_widgets_output);
				do_action( 'asia_garden_action_after_sidebar' );
				if ($asia_garden_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$asia_garden_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>