<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.14
 */
$asia_garden_header_video = asia_garden_get_header_video();
$asia_garden_embed_video = '';
if (!empty($asia_garden_header_video) && !asia_garden_is_from_uploads($asia_garden_header_video)) {
	if (asia_garden_is_youtube_url($asia_garden_header_video) && preg_match('/[=\/]([^=\/]*)$/', $asia_garden_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$asia_garden_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($asia_garden_header_video) . '[/embed]' ));
			$asia_garden_embed_video = asia_garden_make_video_autoplay($asia_garden_embed_video);
		} else {
			$asia_garden_header_video = str_replace('/watch?v=', '/embed/', $asia_garden_header_video);
			$asia_garden_header_video = asia_garden_add_to_url($asia_garden_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url('/'),
				'widgetid' => 1
			));
			$asia_garden_embed_video = '<iframe src="' . esc_url($asia_garden_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php asia_garden_show_layout($asia_garden_embed_video); ?></div><?php
	}
}
?>