<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

// Page (category, tag, archive, author) title
$asia_garden_header_css = $asia_garden_title_image = '';
if (empty($asia_garden_title_image)) 
	$asia_garden_title_image = asia_garden_get_theme_option( 'title_image' );

if ( asia_garden_need_page_title() ) {
	asia_garden_sc_layouts_showed('title', true);
	asia_garden_sc_layouts_showed('postmeta', false);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal sc_layouts_row_background scheme_dark default_image<?php if ($asia_garden_title_image!='') echo ' '.esc_attr(asia_garden_add_inline_css_class('background-image: url('.esc_url($asia_garden_title_image).') !important;'));?>">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$asia_garden_blog_title = asia_garden_get_blog_title();
							$asia_garden_blog_title_text = $asia_garden_blog_title_class = $asia_garden_blog_title_link = $asia_garden_blog_title_link_text = '';
							if (is_array($asia_garden_blog_title)) {
								$asia_garden_blog_title_text = $asia_garden_blog_title['text'];
								$asia_garden_blog_title_class = !empty($asia_garden_blog_title['class']) ? ' '.$asia_garden_blog_title['class'] : '';
								$asia_garden_blog_title_link = !empty($asia_garden_blog_title['link']) ? $asia_garden_blog_title['link'] : '';
								$asia_garden_blog_title_link_text = !empty($asia_garden_blog_title['link_text']) ? $asia_garden_blog_title['link_text'] : '';
							} else
								$asia_garden_blog_title_text = $asia_garden_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($asia_garden_blog_title_class); ?>"><?php
								$asia_garden_top_icon = asia_garden_get_category_icon();
								if (!empty($asia_garden_top_icon)) {
									$asia_garden_attr = asia_garden_getimagesize($asia_garden_top_icon);
									?><img src="<?php echo esc_url($asia_garden_top_icon); ?>" alt="<?php esc_attr__('Image','asia-garden'); ?>" <?php if (!empty($asia_garden_attr[3])) asia_garden_show_layout($asia_garden_attr[3]);?>><?php
								}
								echo wp_kses_post($asia_garden_blog_title_text);
							?></h1>
							<?php
							if (!empty($asia_garden_blog_title_link) && !empty($asia_garden_blog_title_link_text)) {
								?><a href="<?php echo esc_url($asia_garden_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($asia_garden_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>