<?php
/**
 * The template to display the featured image in the single post
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

if ( get_query_var('asia_garden_header_image')=='' && is_singular() && has_post_thumbnail() && in_array(get_post_type(), array('post', 'page')) )  {
	$asia_garden_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
	if (!empty($asia_garden_src[0])) {
		asia_garden_sc_layouts_showed('featured', true);
		?><div class="sc_layouts_featured with_image <?php echo esc_attr(asia_garden_add_inline_css_class('background-image:url('.esc_url($asia_garden_src[0]).');')); ?>"></div><?php
	}
}
?>