<?php
/**
 * The template to display the main menu
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */
?>
<div class="top_panel_navi sc_layouts_row 
			scheme_<?php echo esc_attr(asia_garden_is_inherit(asia_garden_get_theme_option('menu_scheme')) 
												? (asia_garden_is_inherit(asia_garden_get_theme_option('header_scheme')) 
													? asia_garden_get_theme_option('color_scheme') 
													: asia_garden_get_theme_option('header_scheme')) 
												: asia_garden_get_theme_option('menu_scheme')); ?>">
	<div class="columns_wrap">
		<div class="sc_layouts_column sc_layouts_column_align_center sc_layouts_column_icons_position_left column-1_1">
			<?php
			// Logo
			?><div class="sc_layouts_item"><?php
				get_template_part( 'templates/header-logo' );
			?></div>
		</div><div class="sc_layouts_column sc_layouts_column_align_center sc_layouts_column_icons_position_left column-1_1 default_header_border"></div><div class="sc_layouts_column sc_layouts_column_align_center sc_layouts_column_icons_position_left column-1_1">
			<div class="sc_layouts_item">
				<?php
				// Main menu
				$asia_garden_menu_main = asia_garden_get_nav_menu(array(
					'location' => 'menu_main', 
					'class' => 'sc_layouts_menu sc_layouts_menu_default sc_layouts_hide_on_mobile'
					)
				);
				if (empty($asia_garden_menu_main)) {
					$asia_garden_menu_main = asia_garden_get_nav_menu(array(
						'class' => 'sc_layouts_menu sc_layouts_menu_default sc_layouts_hide_on_mobile'
						)
					);
				}
				asia_garden_show_layout($asia_garden_menu_main);
				// Mobile menu button
				?>
				<div class="sc_layouts_iconed_text sc_layouts_menu_mobile_button">
					<a class="sc_layouts_item_link sc_layouts_iconed_text_link" href="#">
						<span class="sc_layouts_item_icon sc_layouts_iconed_text_icon trx_addons_icon-menu"></span>
					</a>
				</div>
			</div><?php
			
			
			?>
		</div>
	</div><!-- /.sc_layouts_row -->
</div><!-- /.top_panel_navi -->