<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(asia_garden_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('asia_garden_logo_args', array('type' => 'mobile'));
		get_template_part( 'templates/header-logo' );
		set_query_var('asia_garden_logo_args', array());

		// Mobile menu
		$asia_garden_menu_mobile = asia_garden_get_nav_menu('menu_mobile');
		if (empty($asia_garden_menu_mobile)) {
			$asia_garden_menu_mobile = apply_filters('asia_garden_filter_get_mobile_menu', '');
			if (empty($asia_garden_menu_mobile)) $asia_garden_menu_mobile = asia_garden_get_nav_menu('menu_main');
			if (empty($asia_garden_menu_mobile)) $asia_garden_menu_mobile = asia_garden_get_nav_menu();
		}
		if (!empty($asia_garden_menu_mobile)) {
			if (!empty($asia_garden_menu_mobile))
				$asia_garden_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$asia_garden_menu_mobile
					);
			if (strpos($asia_garden_menu_mobile, '<nav ')===false)
				$asia_garden_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $asia_garden_menu_mobile);
			asia_garden_show_layout(apply_filters('asia_garden_filter_menu_mobile_layout', $asia_garden_menu_mobile));
		}

		// Search field
		
		
		// Social icons
		
		?>
	</div>
</div>
