<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_args = get_query_var('asia_garden_logo_args');

// Site logo
$asia_garden_logo_image  = asia_garden_get_logo_image(isset($asia_garden_args['type']) ? $asia_garden_args['type'] : '');
$asia_garden_logo_text   = asia_garden_is_on(asia_garden_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$asia_garden_logo_slogan = get_bloginfo( 'description', 'display' );
$header_logo_left_text = asia_garden_get_theme_option('header_logo_left_text');
$header_logo_right_text = asia_garden_get_theme_option('header_logo_right_text');

if (!empty($asia_garden_logo_image) || !empty($asia_garden_logo_text)) {
	?>
    <div class="sc_layouts_logo_container <?php if (!empty($args['logo_left_text'])) echo 'with_left_description'; ?>
    <?php if (!empty($args['logo_right_text'])) echo 'with_right_description'; ?>">
    <?php if (!empty($header_logo_left_text)) {
        ?><div class="logo_left_text">
        <?php asia_garden_show_layout(asia_garden_prepare_macros($header_logo_left_text), '<span>', '</span>'); ?>
        </div>
    <?php } ?>
    <a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($asia_garden_logo_image)) {
			$asia_garden_attr = asia_garden_getimagesize($asia_garden_logo_image);
			echo '<img src="'.esc_url($asia_garden_logo_image).'" alt="'.esc_attr__('Image', 'asia-garden').'"'.(!empty($asia_garden_attr[3]) ? sprintf(' %s', $asia_garden_attr[3]) : '').'>';
		} else {
			asia_garden_show_layout(asia_garden_prepare_macros($asia_garden_logo_text), '<span class="logo_text">', '</span>');
			asia_garden_show_layout(asia_garden_prepare_macros($asia_garden_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php if (!empty($header_logo_right_text)) { ?><div class="logo_right_text"><?php asia_garden_show_layout(asia_garden_prepare_macros($header_logo_right_text), '<span>', '</span>'); ?></div><?php } ?></div><?php
}
?>


