<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */


$asia_garden_header_css = $asia_garden_header_image = '';
$asia_garden_header_video = asia_garden_get_header_video();
if (true || empty($asia_garden_header_video)) {
	$asia_garden_header_image = get_header_image();
	if (asia_garden_is_on(asia_garden_get_theme_option('header_image_override')) && apply_filters('asia_garden_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($asia_garden_cat_img = asia_garden_get_category_image()) != '')
				$asia_garden_header_image = $asia_garden_cat_img;
		} else if (is_singular() || asia_garden_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$asia_garden_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($asia_garden_header_image)) $asia_garden_header_image = $asia_garden_header_image[0];
			} else
				$asia_garden_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
					echo !empty($asia_garden_header_image) || !empty($asia_garden_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($asia_garden_header_video!='') echo ' with_bg_video';
					if ($asia_garden_header_image!='') echo ' '.esc_attr(asia_garden_add_inline_css_class('background-image: url('.esc_url($asia_garden_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (asia_garden_is_on(asia_garden_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(asia_garden_is_inherit(asia_garden_get_theme_option('header_scheme')) 
													? asia_garden_get_theme_option('color_scheme') 
													: asia_garden_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($asia_garden_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (asia_garden_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	

?></header>