<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.06
 */

$asia_garden_header_css = $asia_garden_header_image = '';
$asia_garden_header_video = asia_garden_get_header_video();
if (true || empty($asia_garden_header_video)) {
	$asia_garden_header_image = get_header_image();
	if (asia_garden_is_on(asia_garden_get_theme_option('header_image_override')) && apply_filters('asia_garden_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($asia_garden_cat_img = asia_garden_get_category_image()) != '')
				$asia_garden_header_image = $asia_garden_cat_img;
		} else if (is_singular() || asia_garden_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$asia_garden_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($asia_garden_header_image)) $asia_garden_header_image = $asia_garden_header_image[0];
			} else
				$asia_garden_header_image = '';
		}
	}
}

$asia_garden_header_id = str_replace('header-custom-', '', asia_garden_get_theme_option("header_style"));
if ((int) $asia_garden_header_id == 0) {
	$asia_garden_header_id = asia_garden_get_post_id(array(
												'name' => $asia_garden_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUT_PT') ? TRX_ADDONS_CPT_LAYOUT_PT : 'cpt_layouts'
												)
											);
}
$asia_garden_header_meta = get_post_meta($asia_garden_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($asia_garden_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($asia_garden_header_id)));
				echo !empty($asia_garden_header_image) || !empty($asia_garden_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($asia_garden_header_video!='') 
					echo ' with_bg_video';
				if ($asia_garden_header_image!='') 
					echo ' '.esc_attr(asia_garden_add_inline_css_class('background-image: url('.esc_url($asia_garden_header_image).');'));
				if (!empty($asia_garden_header_meta['margin']) != '') 
					echo ' '.esc_attr(asia_garden_add_inline_css_class('margin-bottom: '.esc_attr(asia_garden_prepare_css_value($asia_garden_header_meta['margin'])).';'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (asia_garden_is_on(asia_garden_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight trx-stretch-height';
				?> scheme_<?php echo esc_attr(asia_garden_is_inherit(asia_garden_get_theme_option('header_scheme')) 
												? asia_garden_get_theme_option('color_scheme') 
												: asia_garden_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($asia_garden_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('asia_garden_action_show_layout', $asia_garden_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>