<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.10
 */

// Footer sidebar
$asia_garden_footer_name = asia_garden_get_theme_option('footer_widgets');
$asia_garden_footer_present = !asia_garden_is_off($asia_garden_footer_name) && is_active_sidebar($asia_garden_footer_name);
if ($asia_garden_footer_present) { 
	asia_garden_storage_set('current_sidebar', 'footer');
	$asia_garden_footer_wide = asia_garden_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($asia_garden_footer_name) ) {
		dynamic_sidebar($asia_garden_footer_name);
	}
	$asia_garden_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($asia_garden_out)) {
		$asia_garden_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $asia_garden_out);
		$asia_garden_need_columns = true;	//or check: strpos($asia_garden_out, 'columns_wrap')===false;
		if ($asia_garden_need_columns) {
			$asia_garden_columns = max(0, (int) asia_garden_get_theme_option('footer_columns'));
			if ($asia_garden_columns == 0) $asia_garden_columns = min(4, max(1, substr_count($asia_garden_out, '<aside ')));
			if ($asia_garden_columns > 1)
				$asia_garden_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($asia_garden_columns).' widget ', $asia_garden_out);
			else
				$asia_garden_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($asia_garden_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$asia_garden_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($asia_garden_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'asia_garden_action_before_sidebar' );
				asia_garden_show_layout($asia_garden_out);
				do_action( 'asia_garden_action_after_sidebar' );
				if ($asia_garden_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$asia_garden_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>