<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.10
 */
$footer_logo_left_text = asia_garden_get_theme_option('footer_logo_left_text');
$footer_logo_right_text = asia_garden_get_theme_option('footer_logo_right_text');

// Logo
if (asia_garden_is_on(asia_garden_get_theme_option('logo_in_footer'))) {
	$asia_garden_logo_image = '';
	if (asia_garden_get_retina_multiplier(2) > 1)
		$asia_garden_logo_image = asia_garden_get_theme_option( 'logo_footer_retina' );
	if (empty($asia_garden_logo_image)) 
		$asia_garden_logo_image = asia_garden_get_theme_option( 'logo_footer' );
	$asia_garden_logo_text   = get_bloginfo( 'name' );
	if (!empty($asia_garden_logo_image) || !empty($asia_garden_logo_text)) {
		?>
<div class="footer_logo_container sc_layouts_logo_container <?php if (!empty($args['logo_left_text'])) echo 'with_left_description'; ?> <?php if (!empty($args['logo_right_text'])) echo 'with_right_description'; ?>"><?php if (!empty($footer_logo_left_text)) { ?><div class="logo_left_text"><?php asia_garden_show_layout(asia_garden_prepare_macros($footer_logo_left_text), '<span>', '</span>'); ?></div><?php } ?><div class="footer_logo_inner">
				<?php
				if (!empty($asia_garden_logo_image)) {
					$asia_garden_attr = asia_garden_getimagesize($asia_garden_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($asia_garden_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'asia-garden').'"'.(!empty($asia_garden_attr[3]) ? sprintf(' %s', $asia_garden_attr[3]) : '').'></a>' ;
				} else if (!empty($asia_garden_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($asia_garden_logo_text) . '</a></h1>';
				}
				?>
			</div><?php if (!empty($footer_logo_right_text)) { ?><div class="logo_right_text"><?php asia_garden_show_layout(asia_garden_prepare_macros($footer_logo_right_text), '<span>', '</span>'); ?></div><?php } ?></div>
		<?php
	}
}
?>