<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.10
 */
$asia_garden_header_css = $asia_garden_footer_image = '';
if (empty($asia_garden_footer_image)) 
	$asia_garden_footer_image = asia_garden_get_theme_option( 'footer_image' );

$asia_garden_footer_scheme =  asia_garden_is_inherit(asia_garden_get_theme_option('footer_scheme')) ? asia_garden_get_theme_option('color_scheme') : asia_garden_get_theme_option('footer_scheme');
?>
<footer class="footer_wrap footer_default scheme_<?php echo esc_attr($asia_garden_footer_scheme); ?> footer_default_image<?php if ($asia_garden_footer_image!='') echo ' '.esc_attr(asia_garden_add_inline_css_class('background-image: url('.esc_url($asia_garden_footer_image).') !important;'));?>">
	<?php

	// Footer widgets area
	get_template_part( 'templates/footer-widgets' );

	// Logo
	get_template_part( 'templates/footer-logo' );

	// Socials
	get_template_part( 'templates/footer-socials' );

	// Menu
	get_template_part( 'templates/footer-menu' );

	// Copyright area
	get_template_part( 'templates/footer-copyright' );
	
	?>
</footer><!-- /.footer_wrap -->
