<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.10
 */

$asia_garden_footer_scheme =  asia_garden_is_inherit(asia_garden_get_theme_option('footer_scheme')) ? asia_garden_get_theme_option('color_scheme') : asia_garden_get_theme_option('footer_scheme');
$asia_garden_footer_id = str_replace('footer-custom-', '', asia_garden_get_theme_option("footer_style"));
if ((int) $asia_garden_footer_id == 0) {
	$asia_garden_footer_id = asia_garden_get_post_id(array(
												'name' => $asia_garden_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUT_PT') ? TRX_ADDONS_CPT_LAYOUT_PT : 'cpt_layouts'
												)
											);
}
$asia_garden_footer_meta = get_post_meta($asia_garden_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($asia_garden_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($asia_garden_footer_id))); 
						if (!empty($asia_garden_footer_meta['margin']) != '') 
							echo ' '.esc_attr(asia_garden_add_inline_css_class('margin-top: '.esc_attr(asia_garden_prepare_css_value($asia_garden_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($asia_garden_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('asia_garden_action_show_layout', $asia_garden_footer_id);
	?>
</footer><!-- /.footer_wrap -->
