<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.10
 */

// Copyright area
$asia_garden_footer_scheme =  asia_garden_is_inherit(asia_garden_get_theme_option('footer_scheme')) ? asia_garden_get_theme_option('color_scheme') : asia_garden_get_theme_option('footer_scheme');
$asia_garden_copyright_scheme = asia_garden_is_inherit(asia_garden_get_theme_option('copyright_scheme')) ? $asia_garden_footer_scheme : asia_garden_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($asia_garden_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text trx_addons_copyright"><?php
				// Replace {{...}} and [[...]] on the <i>...</i> and <b>...</b>
				$asia_garden_copyright = asia_garden_prepare_macros(asia_garden_get_theme_option('copyright'));
				if (!empty($asia_garden_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $asia_garden_copyright, $asia_garden_matches)) {
						$asia_garden_copyright = str_replace($asia_garden_matches[1], date(str_replace(array('{', '}'), '', $asia_garden_matches[1])), $asia_garden_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($asia_garden_copyright));
				}
			?></div>
		</div>
	</div>
</div>
