<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0.1
 */
 
$asia_garden_theme_obj = wp_get_theme();
?>
<div class="update-nag" id="asia_garden_admin_notice">
	<h3 class="asia_garden_notice_title"><?php echo sprintf(esc_html__('Welcome to %s v.%s', 'asia-garden'), $asia_garden_theme_obj->name, $asia_garden_theme_obj->version); ?></h3>
	<?php
	if (!asia_garden_exists_trx_addons()) {
		?><p><?php echo wp_kses_data(__('<b>Attention!</b> Plugin "ThemeREX Addons is required! Please, install and activate it!', 'asia-garden')); ?></p><?php
	}
	?><p>
		<a href="<?php echo esc_url(admin_url().'themes.php?page=asia_garden_about'); ?>" class="button-primary"><i class="dashicons dashicons-nametag"></i> <?php echo sprintf(esc_html__('About %s', 'asia-garden'), $asia_garden_theme_obj->name); ?></a>
		<?php
		if (asia_garden_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'asia-garden'); ?></a>
			<?php
		}
		if (function_exists('asia_garden_exists_trx_addons') && asia_garden_exists_trx_addons() && class_exists('trx_addons_demo_data_importer')) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'asia-garden'); ?></a>
			<?php
		}
		?>
        <a href="<?php echo esc_url(admin_url().'themes.php?page=theme_options'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Options', 'asia-garden'); ?></a>
		<span> <?php esc_html_e('or', 'asia-garden'); ?> </span>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'asia-garden'); ?></a>
        <a href="#" class="button asia_garden_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'asia-garden'); ?></a>
	</p>
</div>