<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

if (asia_garden_sidebar_present()) {
	ob_start();
	$asia_garden_sidebar_name = asia_garden_get_theme_option('sidebar_widgets');
	asia_garden_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($asia_garden_sidebar_name) ) {
		dynamic_sidebar($asia_garden_sidebar_name);
	}
	$asia_garden_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($asia_garden_out)) {
		$asia_garden_sidebar_position = asia_garden_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($asia_garden_sidebar_position); ?> widget_area<?php if (!asia_garden_is_inherit(asia_garden_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(asia_garden_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'asia_garden_action_before_sidebar' );
				asia_garden_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $asia_garden_out));
				do_action( 'asia_garden_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>