<?php
/* YITH WooCommerce Compare support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'asia_garden_yith_wishlist_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'asia_garden_yith_wishlist_theme_setup9', 9 );
    function asia_garden_yith_wishlist_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'asia_garden_filter_tgmpa_required_plugins', 'asia_garden_yith_wishlist_tgmpa_required_plugins' );
            add_filter( 'asia_garden_filter_theme_plugins', 'asia_garden_yith_wishlist_theme_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'asia_garden_yith_wishlist_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('asia_garden_filter_tgmpa_required_plugins',	'asia_garden_yith_wishlist_tgmpa_required_plugins');
    function asia_garden_yith_wishlist_tgmpa_required_plugins( $list = array() ) {
        if (asia_garden_storage_isset('required_plugins', 'yith-woocommerce-wishlist')) {
            // yith wishlist plugin
            $list[] = array(
                'name'     => asia_garden_storage_get_array( 'required_plugins', 'yith-woocommerce-wishlist'),
                'slug'     => 'yith-woocommerce-wishlist',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if yith installed and activated
if ( ! function_exists( 'asia_garden_exists_yith_wishlist' ) ) {
    function asia_garden_exists_yith_wishlist() {
        return defined( 'YITH_WCWL_DIR' );
    }
}

// Set plugin's specific importer options
if ( !function_exists( 'asia_garden_yith_wishlist_importer_set_options' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_options',	'asia_garden_yith_wishlist_importer_set_options' );
    function asia_garden_yith_wishlist_importer_set_options($options=array()) {
        if ( asia_garden_exists_yith_wishlist() && in_array('yith-woocommerce-wishlist', $options['required_plugins']) ) {
            $options['additional_options'][] = 'yith_wcwl_%';
        }
        return $options;
    }
}
