<?php
/* Woocommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('asia_garden_woocommerce_theme_setup1')) {
	add_action( 'after_setup_theme', 'asia_garden_woocommerce_theme_setup1', 1 );
	function asia_garden_woocommerce_theme_setup1() {

		add_theme_support( 'woocommerce' );

		// Next setting from the WooCommerce 3.0+ enable built-in image zoom on the single product page
		add_theme_support( 'wc-product-gallery-zoom' );

		// Next setting from the WooCommerce 3.0+ enable built-in image slider on the single product page
		add_theme_support( 'wc-product-gallery-slider' ); 

		// Next setting from the WooCommerce 3.0+ enable built-in image lightbox on the single product page
		add_theme_support( 'wc-product-gallery-lightbox' );

		add_filter( 'asia_garden_filter_list_sidebars', 	'asia_garden_woocommerce_list_sidebars' );
		add_filter( 'asia_garden_filter_list_posts_types',	'asia_garden_woocommerce_list_post_types');
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('asia_garden_woocommerce_theme_setup3')) {
	add_action( 'after_setup_theme', 'asia_garden_woocommerce_theme_setup3', 3 );
	function asia_garden_woocommerce_theme_setup3() {
		if (asia_garden_exists_woocommerce()) {
		
			// Section 'WooCommerce'
			asia_garden_storage_merge_array('options', '', array_merge(
				array(
					'shop' => array(
						"title" => esc_html__('Shop', 'asia-garden'),
						"desc" => wp_kses_data( __('Select parameters to display the shop pages', 'asia-garden') ),
						"type" => "section"
						),

					'products_info_shop' => array(
						"title" => esc_html__('Products list', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),


					'shop_mode' => array(
						"title" => esc_html__('Shop mode', 'asia-garden'),
						"desc" => wp_kses_data( __('Select style for the products list', 'asia-garden') ),
						"std" => 'thumbs',
						"options" => array(
							'thumbs'=> esc_html__('Thumbnails', 'asia-garden'),
							'list'	=> esc_html__('List', 'asia-garden'),
						),
						"type" => "select"
						),
					'shop_hover' => array(
						"title" => esc_html__('Hover style', 'asia-garden'),
						"desc" => wp_kses_data( __('Hover style on the products in the shop archive', 'asia-garden') ),
						"std" => 'none',
						"options" => apply_filters('asia_garden_filter_shop_hover', array(
							'none' => esc_html__('None', 'asia-garden'),
							'dots' => esc_html__('Dots', 'asia-garden')
							
							
						)),
						"type" => "select"
						),

					'single_info_shop' => array(
						"title" => esc_html__('Single product', 'asia-garden'),
						"desc" => '',
						"type" => "info",
						),
					'stretch_tabs_area' => array(
						"title" => esc_html__('Stretch tabs area', 'asia-garden'),
						"desc" => wp_kses_data( __('Stretch area with tabs on the single product to the screen width if the sidebar is hidden', 'asia-garden') ),
						"std" => 1,
						"type" => "checkbox"
						),
					'show_related_posts_shop' => array(
						"title" => esc_html__('Show related products', 'asia-garden'),
						"desc" => wp_kses_data( __("Show section 'Related products' on the single product page", 'asia-garden') ),
						"std" => 1,
						"type" => "checkbox"
						),
					'related_posts_shop' => array(
						"title" => esc_html__('Related products', 'asia-garden'),
						"desc" => wp_kses_data( __('How many related products should be displayed on the single product page?', 'asia-garden') ),
						"dependency" => array(
							'show_related_posts_shop' => array('1')
						),
						"std" => 3,
						"options" => asia_garden_get_list_range(1,9),
						"type" => "select"
						),
					'related_columns_shop' => array(
						"title" => esc_html__('Related columns', 'asia-garden'),
						"desc" => wp_kses_data( __('How many columns should be used to output related products on the single product page?', 'asia-garden') ),
						"dependency" => array(
							'show_related_posts_shop' => array('1')
						),
						"std" => 3,
						"options" => asia_garden_get_list_range(1,4),
						"type" => "select"
						)
				),
				asia_garden_options_get_list_cpt_options('shop')
			));
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_woocommerce_theme_setup9')) {
	add_action( 'after_setup_theme', 'asia_garden_woocommerce_theme_setup9', 9 );
	function asia_garden_woocommerce_theme_setup9() {
		
		if (asia_garden_exists_woocommerce()) {
			add_action( 'wp_enqueue_scripts', 								'asia_garden_woocommerce_frontend_scripts', 1100 );
			add_filter( 'asia_garden_filter_merge_styles',						'asia_garden_woocommerce_merge_styles' );
			add_filter( 'asia_garden_filter_merge_scripts',						'asia_garden_woocommerce_merge_scripts');
			add_filter( 'asia_garden_filter_get_post_info',		 				'asia_garden_woocommerce_get_post_info');
			add_filter( 'asia_garden_filter_post_type_taxonomy',				'asia_garden_woocommerce_post_type_taxonomy', 10, 2 );
			if (!is_admin()) {
				add_filter( 'asia_garden_filter_detect_blog_mode',				'asia_garden_woocommerce_detect_blog_mode');
				add_filter( 'asia_garden_filter_get_post_categories', 			'asia_garden_woocommerce_get_post_categories');
				add_filter( 'asia_garden_filter_allow_override_header_image',	'asia_garden_woocommerce_allow_override_header_image');
				add_filter( 'asia_garden_filter_get_blog_title',				'asia_garden_woocommerce_get_blog_title');
				add_action( 'asia_garden_action_before_post_meta',				'asia_garden_woocommerce_action_before_post_meta');
				add_filter( 'asia_garden_filter_localize_script',				'asia_garden_woocommerce_localize_script');
			}
		}
		if (is_admin()) {
			add_filter( 'asia_garden_filter_tgmpa_required_plugins',			'asia_garden_woocommerce_tgmpa_required_plugins' );
		}

		// Add wrappers and classes to the standard WooCommerce output
		if (asia_garden_exists_woocommerce()) {

			// Remove WOOC sidebar
			remove_action( 'woocommerce_sidebar', 						'woocommerce_get_sidebar', 10 );

			// Remove link around product item
			remove_action('woocommerce_before_shop_loop_item',			'woocommerce_template_loop_product_link_open', 10);
			remove_action('woocommerce_after_shop_loop_item',			'woocommerce_template_loop_product_link_close', 5);


			// Add Wishlist button
			if ( get_option('yith_woocompare_compare_button_in_products_list') == 'yes' ) {
				add_action( 'woocommerce_after_shop_loop_item', 'asia_garden_woocommerce_add_wishlist_wrap', 19 );
				add_action( 'woocommerce_after_shop_loop_item', 'asia_garden_woocommerce_add_wishlist_link', 20 );
			}
			
			
			// Remove link around product category
			remove_action('woocommerce_before_subcategory',				'woocommerce_template_loop_category_link_open', 10);
			remove_action('woocommerce_after_subcategory',				'woocommerce_template_loop_category_link_close', 10);
			
			// Open main content wrapper - <article>
			remove_action( 'woocommerce_before_main_content',			'woocommerce_output_content_wrapper', 10);
			add_action(    'woocommerce_before_main_content',			'asia_garden_woocommerce_wrapper_start', 10);
			// Close main content wrapper - </article>
			remove_action( 'woocommerce_after_main_content',			'woocommerce_output_content_wrapper_end', 10);		
			add_action(    'woocommerce_after_main_content',			'asia_garden_woocommerce_wrapper_end', 10);

			// Close header section
			add_action(    'woocommerce_archive_description',			'asia_garden_woocommerce_archive_description', 15 );

			// Add theme specific search form
			add_filter(    'get_product_search_form',					'asia_garden_woocommerce_get_product_search_form' );

			// Change text on 'Add to cart' button
			add_filter(    'woocommerce_product_add_to_cart_text',		'asia_garden_woocommerce_add_to_cart_text' );
			add_filter(    'woocommerce_product_single_add_to_cart_text','asia_garden_woocommerce_add_to_cart_text' );

			// Add list mode buttons
			add_action(    'woocommerce_before_shop_loop', 				'asia_garden_woocommerce_before_shop_loop', 10 );


			// Open product/category item wrapper
			add_action(    'woocommerce_before_subcategory_title',		'asia_garden_woocommerce_item_wrapper_start', 9 );
			add_action(    'woocommerce_before_shop_loop_item_title',	'asia_garden_woocommerce_item_wrapper_start', 9 );
			// Close featured image wrapper and open title wrapper
			add_action(    'woocommerce_before_subcategory_title',		'asia_garden_woocommerce_title_wrapper_start', 20 );
			add_action(    'woocommerce_before_shop_loop_item_title',	'asia_garden_woocommerce_title_wrapper_start', 20 );

			// Add tags before title
			

			// Wrap product title into link
			add_action(    'the_title',									'asia_garden_woocommerce_the_title');
			// Wrap category title into link
            remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );
			add_action(		'woocommerce_shop_loop_subcategory_title',  'asia_garden_woocommerce_shop_loop_subcategory_title', 9, 1);

			// Close title wrapper and add description in the list mode
			add_action(    'woocommerce_after_shop_loop_item_title',	'asia_garden_woocommerce_title_wrapper_end', 7);
			add_action(    'woocommerce_after_subcategory_title',		'asia_garden_woocommerce_title_wrapper_end2', 10 );
			// Close product/category item wrapper
			add_action(    'woocommerce_after_subcategory',				'asia_garden_woocommerce_item_wrapper_end', 20 );
			add_action(    'woocommerce_after_shop_loop_item',			'asia_garden_woocommerce_item_wrapper_end', 20 );

			// Add product ID into product meta section (after categories and tags)
			add_action(    'woocommerce_product_meta_end',				'asia_garden_woocommerce_show_product_id', 10);
			
			// Set columns number for the product's thumbnails
			add_filter(    'woocommerce_product_thumbnails_columns',	'asia_garden_woocommerce_product_thumbnails_columns' );

			// Decorate price
			

	
			// Detect current shop mode
			if (!is_admin()) {
				$shop_mode = asia_garden_get_value_gpc('asia_garden_shop_mode');
				if (empty($shop_mode) && asia_garden_check_theme_option('shop_mode'))
					$shop_mode = asia_garden_get_theme_option('shop_mode');
				if (empty($shop_mode))
					$shop_mode = 'thumbs';
				asia_garden_storage_set('shop_mode', $shop_mode);
			}
		}
	}
}

// Theme init priorities:
// Action 'wp'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)
if (!function_exists('asia_garden_woocommerce_theme_setup_wp')) {
	add_action( 'wp', 'asia_garden_woocommerce_theme_setup_wp' );
	function asia_garden_woocommerce_theme_setup_wp() {
		if (asia_garden_exists_woocommerce()) {
			// Set columns number for the related products
			if ((int) asia_garden_get_theme_option('show_related_posts') == 0 || (int) asia_garden_get_theme_option('related_posts') == 0) {
				remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
			} else {
				add_filter(    'woocommerce_output_related_products_args',	'asia_garden_woocommerce_output_related_products_args' );
				add_filter(    'woocommerce_related_products_columns',		'asia_garden_woocommerce_related_products_columns' );
			}
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_woocommerce_tgmpa_required_plugins' ) ) {
	
	function asia_garden_woocommerce_tgmpa_required_plugins($list=array()) {
		if (asia_garden_storage_isset('required_plugins', 'woocommerce')) {
			$list[] = array(
					'name' 		=> asia_garden_storage_get_array('required_plugins', 'woocommerce'),
					'slug' 		=> 'woocommerce',
					'required' 	=> false
			);
			$list[] = array(
					'name' 		=> asia_garden_storage_get_array('required_plugins', 'yith-woocommerce-wishlist'),
					'slug' 		=> 'yith-woocommerce-wishlist',
					'required' 	=> false
			);
		}
		return $list;
	}
}


// Check if WooCommerce installed and activated
if ( !function_exists( 'asia_garden_exists_woocommerce' ) ) {
	function asia_garden_exists_woocommerce() {
		return class_exists('Woocommerce');
		
	}
}

// Return true, if current page is any woocommerce page
if ( !function_exists( 'asia_garden_is_woocommerce_page' ) ) {
	function asia_garden_is_woocommerce_page() {
		$rez = false;
		if (asia_garden_exists_woocommerce())
			$rez = is_woocommerce() || is_shop() || is_product() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_cart() || is_checkout() || is_account_page();
		return $rez;
	}
}

// Detect current blog mode
if ( !function_exists( 'asia_garden_woocommerce_detect_blog_mode' ) ) {
	
	function asia_garden_woocommerce_detect_blog_mode($mode='') {
		if (is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy())
			$mode = 'shop';
		else if (is_product() || is_cart() || is_checkout() || is_account_page())
			$mode = 'shop';	
		return $mode;
	}
}

// Return current page title
if ( !function_exists( 'asia_garden_woocommerce_get_blog_title' ) ) {
	
	function asia_garden_woocommerce_get_blog_title($title='') {
		if (!asia_garden_exists_trx_addons() && asia_garden_exists_woocommerce() && asia_garden_is_woocommerce_page() && is_shop()) {
			$id = asia_garden_woocommerce_get_shop_page_id();
			$title = $id ? get_the_title($id) : esc_html__('Shop', 'asia-garden');
		}
		return $title;
	}
}


// Return taxonomy for current post type
if ( !function_exists( 'asia_garden_woocommerce_post_type_taxonomy' ) ) {
	
	function asia_garden_woocommerce_post_type_taxonomy($tax='', $post_type='') {
		if ($post_type == 'product')
			$tax = 'product_cat';
		return $tax;
	}
}

// Return true if page title section is allowed
if ( !function_exists( 'asia_garden_woocommerce_allow_override_header_image' ) ) {
	
	function asia_garden_woocommerce_allow_override_header_image($allow=true) {
		return is_product() ? false : $allow;
	}
}

// Return shop page ID
if ( !function_exists( 'asia_garden_woocommerce_get_shop_page_id' ) ) {
	function asia_garden_woocommerce_get_shop_page_id() {
		return get_option('woocommerce_shop_page_id');
	}
}

// Return shop page link
if ( !function_exists( 'asia_garden_woocommerce_get_shop_page_link' ) ) {
	function asia_garden_woocommerce_get_shop_page_link() {
		$url = '';
		$id = asia_garden_woocommerce_get_shop_page_id();
		if ($id) $url = get_permalink($id);
		return $url;
	}
}

// Show categories of the current product
if ( !function_exists( 'asia_garden_woocommerce_get_post_categories' ) ) {
	
	function asia_garden_woocommerce_get_post_categories($cats='') {
		if (get_post_type()=='product') {
			$cats = asia_garden_get_post_terms(', ', get_the_ID(), 'product_cat');
		}
		return $cats;
	}
}

// Add 'product' to the list of the supported post-types
if ( !function_exists( 'asia_garden_woocommerce_list_post_types' ) ) {
	
	function asia_garden_woocommerce_list_post_types($list=array()) {
		$list['product'] = esc_html__('Products', 'asia-garden');
		return $list;
	}
}

// Show price of the current product in the widgets and search results
if ( !function_exists( 'asia_garden_woocommerce_get_post_info' ) ) {
	
	function asia_garden_woocommerce_get_post_info($post_info='') {
		if (get_post_type()=='product') {
			global $product;
			if ( $price_html = $product->get_price_html() ) {
				$post_info = '<div class="post_price product_price price">' . trim($price_html) . '</div>' . $post_info;
			}
		}
		return $post_info;
	}
}

// Show price of the current product in the search results streampage
if ( !function_exists( 'asia_garden_woocommerce_action_before_post_meta' ) ) {
	
	function asia_garden_woocommerce_action_before_post_meta() {
		if (!is_single() && get_post_type()=='product') {
			global $product;
			if ( $price_html = $product->get_price_html() ) {
				?><div class="post_price product_price price"><?php asia_garden_show_layout($price_html); ?></div><?php
			}
		}
	}
}
	
// Enqueue WooCommerce custom styles
if ( !function_exists( 'asia_garden_woocommerce_frontend_scripts' ) ) {
	
	function asia_garden_woocommerce_frontend_scripts() {
		
			if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/woocommerce/woocommerce.css')!='')
				wp_enqueue_style( 'asia-garden-woocommerce',  asia_garden_get_file_url('plugins/woocommerce/woocommerce.css'), array(), null );
			if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/woocommerce/woocommerce.js')!='')
				wp_enqueue_script( 'asia-garden-woocommerce', asia_garden_get_file_url('plugins/woocommerce/woocommerce.js'), array('jquery'), null, true );
	}
}
	
// Merge custom styles
if ( !function_exists( 'asia_garden_woocommerce_merge_styles' ) ) {
	
	function asia_garden_woocommerce_merge_styles($list) {
		$list[] = 'plugins/woocommerce/woocommerce.css';
		return $list;
	}
}
	
// Merge custom scripts
if ( !function_exists( 'asia_garden_woocommerce_merge_scripts' ) ) {
	
	function asia_garden_woocommerce_merge_scripts($list) {
		$list[] = 'plugins/woocommerce/woocommerce.js';
		return $list;
	}
}



// Add WooCommerce specific items into lists
//------------------------------------------------------------------------

// Add sidebar
if ( !function_exists( 'asia_garden_woocommerce_list_sidebars' ) ) {
	
	function asia_garden_woocommerce_list_sidebars($list=array()) {
		$list['woocommerce_widgets'] = array(
											'name' => esc_html__('WooCommerce Widgets', 'asia-garden'),
											'description' => esc_html__('Widgets to be shown on the WooCommerce pages', 'asia-garden')
											);
		return $list;
	}
}




// Decorate WooCommerce output: Loop
//------------------------------------------------------------------------


// Before main content
if ( !function_exists( 'asia_garden_woocommerce_wrapper_start' ) ) {
	
	
	function asia_garden_woocommerce_wrapper_start() {
		if (is_product() || is_cart() || is_checkout() || is_account_page()) {
			?>
			<article class="post_item_single post_type_product">
			<?php
		} else {
			?>
			<div class="list_products shop_mode_<?php echo !asia_garden_storage_empty('shop_mode') ? asia_garden_storage_get('shop_mode') : 'thumbs'; ?>">
				<div class="list_products_header">
			<?php
		}
	}
}

// After main content
if ( !function_exists( 'asia_garden_woocommerce_wrapper_end' ) ) {
	
	
	function asia_garden_woocommerce_wrapper_end() {
		if (is_product() || is_cart() || is_checkout() || is_account_page()) {
			?>
			</article><!-- /.post_item_single -->
			<?php
		} else {
			?>
			</div><!-- /.list_products -->
			<?php
		}
	}
}

// Close header section
if ( !function_exists( 'asia_garden_woocommerce_archive_description' ) ) {
	
	function asia_garden_woocommerce_archive_description() {
		?>
		</div><!-- /.list_products_header -->
		<?php
	}
}

// Add list mode buttons
if ( !function_exists( 'asia_garden_woocommerce_before_shop_loop' ) ) {
	
	function asia_garden_woocommerce_before_shop_loop() {
		?>
		<div class="asia_garden_shop_mode_buttons"><form action="<?php echo esc_url(asia_garden_get_current_url()); ?>" method="post"><input type="hidden" name="asia_garden_shop_mode" value="<?php echo esc_attr(asia_garden_storage_get('shop_mode')); ?>" /><a href="#" class="woocommerce_thumbs icon-th" title="<?php esc_attr_e('Show products as thumbs', 'asia-garden'); ?>"></a><a href="#" class="woocommerce_list icon-th-list" title="<?php esc_attr_e('Show products as list', 'asia-garden'); ?>"></a></form></div><!-- /.asia_garden_shop_mode_buttons -->
		<?php
	}
}



// Open item wrapper for categories and products
if ( !function_exists( 'asia_garden_woocommerce_item_wrapper_start' ) ) {
	
	
	function asia_garden_woocommerce_item_wrapper_start($cat='') {
		asia_garden_storage_set('in_product_item', true);
		$hover = asia_garden_get_theme_option('shop_hover');
		?>
		<div class="post_item post_layout_<?php
            echo esc_attr( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy()
                ? asia_garden_storage_get( 'shop_mode' )
                : 'thumbs'
            );
            ?>">
			<div class="post_featured hover_<?php echo esc_attr($hover); ?>">
				<?php do_action('asia_garden_action_woocommerce_item_featured_start'); ?>

				    <a href="<?php echo esc_url(is_object($cat) ? get_term_link($cat->slug, 'product_cat') : get_permalink()); ?>">


				<?php
	}
}

// Open item wrapper for categories and products
if ( !function_exists( 'asia_garden_woocommerce_open_item_wrapper' ) ) {
	
	
	function asia_garden_woocommerce_title_wrapper_start($cat='') {
				?>
				<?php
				$hover = asia_garden_get_theme_option( 'shop_hover' );
				if ( 'none' != $hover ) {
					?>
					<div class="mask"></div>
					<?php
					asia_garden_hovers_add_icons( $hover, array( 'cat' => $cat ) );
				}
				do_action( 'asia_garden_action_woocommerce_item_featured_end' );
				?>
			</div><!-- /.post_featured -->
			<div class="post_data">
				<div class="post_data_inner">
					<div class="post_header entry-header">
					<?php
	}
}


// Display product's tags before the title
if ( !function_exists( 'asia_garden_woocommerce_title_tags' ) ) {
	
	function asia_garden_woocommerce_title_tags() {
		global $product;
		asia_garden_show_layout(wc_get_product_tag_list( $product->get_id(), ', ', '<div class="post_tags product_tags">', '</div>' ));
	}
}

// Wrap product title into link
if ( !function_exists( 'asia_garden_woocommerce_the_title' ) ) {
	
	function asia_garden_woocommerce_the_title($title) {
		if (asia_garden_storage_get('in_product_item') && get_post_type()=='product') {
			$title = '<a href="'.get_permalink().'">'.esc_html($title).'</a>';
		}
		return $title;
	}
}

// Wrap category title into link
if ( !function_exists( 'asia_garden_woocommerce_shop_loop_subcategory_title' ) ) {
    function asia_garden_woocommerce_shop_loop_subcategory_title($cat) {

        $cat->name = sprintf('<a href="%s">%s</a>', esc_url(get_term_link($cat->slug, 'product_cat')), $cat->name);
        ?>
        <h2 class="woocommerce-loop-category__title">
        <?php
        asia_garden_show_layout($cat->name);

        if ( $cat->count > 0 ) {
            echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count">(' . esc_html( $cat->count ) . ')</mark>', $cat ); // WPCS: XSS ok.
        }
        ?>
        </h2><?php
    }
}

// Add excerpt in output for the product in the list mode
if ( !function_exists( 'asia_garden_woocommerce_title_wrapper_end' ) ) {
	
	function asia_garden_woocommerce_title_wrapper_end() {
			?>
			</div><!-- /.post_header -->
		<?php
		if (asia_garden_storage_get('shop_mode') == 'list' && (is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy()) && !is_product()) {
		    $excerpt = apply_filters('the_excerpt', get_the_excerpt());
			?>
			<div class="post_content entry-content"><?php asia_garden_show_layout($excerpt); ?></div>
			<?php
		}
	}
}

// Add excerpt in output for the product in the list mode
if ( !function_exists( 'asia_garden_woocommerce_title_wrapper_end2' ) ) {
	
	function asia_garden_woocommerce_title_wrapper_end2($category) {
			?>
			</div><!-- /.post_header -->
		<?php
		if (asia_garden_storage_get('shop_mode') == 'list' && is_shop() && !is_product()) {
			?>
			<div class="post_content entry-content"><?php asia_garden_show_layout($category->description); ?></div><!-- /.post_content -->
			<?php
		}
	}
}

// Close item wrapper for categories and products
if ( !function_exists( 'asia_garden_woocommerce_close_item_wrapper' ) ) {
	
	
	function asia_garden_woocommerce_item_wrapper_end($cat='') {
				?>
				</div><!-- /.post_data_inner -->
			</div><!-- /.post_data -->
		</div><!-- /.post_item -->
		<?php
		asia_garden_storage_set('in_product_item', false);
	}
}

// Change text on 'Add to cart' button
if ( ! function_exists( 'asia_garden_woocommerce_add_to_cart_text' ) ) {
    function asia_garden_woocommerce_add_to_cart_text( $text = '' ) {
        global $product;
            return is_object( $product ) && $product->is_in_stock()
            && 'grouped' !== $product->get_type()
            && ( 'external' !== $product->get_type() || $product->get_button_text() == '' )
            ? esc_html__( 'Add to Cart', 'asia-garden' )
            : $text;
    }
}

// Add wrap for buttons 'Compare' and 'Add to wishlist'
if ( ! function_exists( 'asia_garden_woocommerce_add_wishlist_wrap' ) ) {
	//Handler of the add_action( 'woocommerce_after_shop_loop_item', 'asia_garden_woocommerce_add_wishlist_wrap' ), 19 );
	function asia_garden_woocommerce_add_wishlist_wrap() {
		if ( function_exists( 'YITH_WCWL' ) ) {
			?><div class="yith_buttons_wrap"><?php
		}
	}
}

// Add button 'Add to wishlist'
if ( ! function_exists( 'asia_garden_woocommerce_add_wishlist_link' ) ) {
	//Handler of the add_action( 'woocommerce_after_shop_loop_item', 'asia_garden_woocommerce_add_wishlist_link' ), 20 );
	function asia_garden_woocommerce_add_wishlist_link() {
		if ( function_exists( 'YITH_WCWL' ) ) {
			$enabled_on_loop = 'yes' == get_option( 'yith_wcwl_show_on_loop' );
			$position = get_option( 'yith_wcwl_loop_position' );
			if ( $enabled_on_loop && 'before_image' == $position ) {
				asia_garden_show_layout( do_shortcode( '[yith_wcwl_add_to_wishlist]' ) );
			}
			?></div><?php
		}
	}
}

// Decorate price
if ( !function_exists( 'asia_garden_woocommerce_get_price_html' ) ) {
	
	function asia_garden_woocommerce_get_price_html($price='') {
		if (!is_admin() && !empty($price)) {
			$sep = get_option('woocommerce_price_decimal_sep');
			if (empty($sep)) $sep = '.';
			$price = preg_replace('/([0-9,]+)(\\'.trim($sep).')([0-9]{2})/', '\\1<span class="decimals">\\3</span>', $price);
		}
		return $price;
	}
}



// Decorate WooCommerce output: Single product
//------------------------------------------------------------------------

// Add WooCommerce specific vars into localize array
if (!function_exists('asia_garden_woocommerce_localize_script')) {
	
	function asia_garden_woocommerce_localize_script($arr) {
		$arr['stretch_tabs_area'] = !asia_garden_sidebar_present() ? asia_garden_get_theme_option('stretch_tabs_area') : 0;
		return $arr;
	}
}

// Add Product ID for the single product
if ( !function_exists( 'asia_garden_woocommerce_show_product_id' ) ) {
	
	function asia_garden_woocommerce_show_product_id() {
		$authors = wp_get_post_terms(get_the_ID(), 'pa_product_author');
		if (is_array($authors) && count($authors)>0) {
			echo '<span class="product_author">'.esc_html__('Author: ', 'asia-garden');
			$delim = '';
			foreach ($authors as $author) {
				echo  esc_html($delim) . '<span>' . esc_html($author->name) . '</span>';
				$delim = ', ';
			}
			echo '</span>';
		}
		echo '<span class="product_id">'.esc_html__('Product ID: ', 'asia-garden') . '<span>' . get_the_ID() . '</span></span>';
	}
}

// Number columns for the product's thumbnails
if ( !function_exists( 'asia_garden_woocommerce_product_thumbnails_columns' ) ) {
	
	function asia_garden_woocommerce_product_thumbnails_columns($cols) {
		return 4;
	}
}

// Set products number for the related products
if ( !function_exists( 'asia_garden_woocommerce_output_related_products_args' ) ) {
	
	function asia_garden_woocommerce_output_related_products_args($args) {
		$args['posts_per_page'] = (int) asia_garden_get_theme_option('show_related_posts') 
										? max(0, min(9, asia_garden_get_theme_option('related_posts'))) 
										: 0;
		$args['columns'] = max(1, min(4, asia_garden_get_theme_option('related_columns')));
		return $args;
	}
}

// Set columns number for the related products
if ( !function_exists( 'asia_garden_woocommerce_related_products_columns' ) ) {
	
	function asia_garden_woocommerce_related_products_columns($columns) {
		$columns = max(1, min(4, asia_garden_get_theme_option('related_columns')));
		return $columns;
	}
}



// Decorate WooCommerce output: Widgets
//------------------------------------------------------------------------

// Search form
if ( !function_exists( 'asia_garden_woocommerce_get_product_search_form' ) ) {
	
	function asia_garden_woocommerce_get_product_search_form($form) {
		return '
		<form role="search" method="get" class="search_form" action="' . esc_url(home_url('/')) . '">
			<input type="text" class="search_field" placeholder="' . esc_attr__('Search for products &hellip;', 'asia-garden') . '" value="' . get_search_query() . '" name="s" /><button class="search_button" type="submit">' . esc_html__('Search', 'asia-garden') . '</button>
			<input type="hidden" name="post_type" value="product" />
		</form>
		';
	}
}

if ( ! function_exists( 'asia_garden_woocommerce_price_filter_widget_step' ) ) {
    add_filter('woocommerce_price_filter_widget_step', 'asia_garden_woocommerce_price_filter_widget_step');
    function asia_garden_woocommerce_price_filter_widget_step( $step = '' ) {
        $step = 1;
        return $step;
    }
}

// Add plugin-specific colors and fonts to the custom CSS
if (asia_garden_exists_woocommerce()) { require_once ASIA_GARDEN_THEME_DIR . 'plugins/woocommerce/woocommerce.styles.php'; }
?>