<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_trx_updater_theme_setup9')) {
    add_action( 'after_setup_theme', 'asia_garden_trx_updater_theme_setup9', 9 );
    function asia_garden_trx_updater_theme_setup9() {
        if (is_admin()) {
            add_filter( 'asia_garden_filter_tgmpa_required_plugins',		'asia_garden_trx_updater_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_trx_updater_tgmpa_required_plugins' ) ) {
    function asia_garden_trx_updater_tgmpa_required_plugins($list=array()) {
        if (asia_garden_storage_isset('required_plugins', 'trx_updater')) {
            $path = asia_garden_get_file_dir('plugins/trx_updater/trx_updater.zip');
            $list[] = array(
                'name' 		=> asia_garden_storage_get_array('required_plugins', 'trx_updater'),
                'slug' 		=> 'trx_updater',
                'version'	=> '1.9.8',
                'source'	=> !empty($path) ? $path : 'upload://trx_updater.zip',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if this plugin installed and activated
if ( ! function_exists( 'asia_garden_exists_trx_updater' ) ) {
    function asia_garden_exists_trx_updater() {
        return function_exists( 'trx_updater_load_plugin_textdomain' );
    }
}


?>