<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'asia_garden_mailchimp_theme_setup9', 9 );
	function asia_garden_mailchimp_theme_setup9() {
		if (asia_garden_exists_mailchimp()) {
			add_action( 'wp_enqueue_scripts',							'asia_garden_mailchimp_frontend_scripts', 1100 );
			add_filter( 'asia_garden_filter_merge_styles',					'asia_garden_mailchimp_merge_styles');
		}
		if (is_admin()) {
			add_filter( 'asia_garden_filter_tgmpa_required_plugins',		'asia_garden_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_mailchimp_tgmpa_required_plugins' ) ) {
	
	function asia_garden_mailchimp_tgmpa_required_plugins($list=array()) {
		if (asia_garden_storage_isset('required_plugins', 'mailchimp-for-wp')) {
			$list[] = array(
				'name' 		=> asia_garden_storage_get_array('required_plugins', 'mailchimp-for-wp'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'asia_garden_exists_mailchimp' ) ) {
	function asia_garden_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'asia_garden_mailchimp_frontend_scripts' ) ) {
	
	function asia_garden_mailchimp_frontend_scripts() {
		if (asia_garden_exists_mailchimp()) {
			if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/mailchimp-for-wp/mailchimp-for-wp.css')!='')
				wp_enqueue_style( 'asia-garden-mailchimp-for-wp',  asia_garden_get_file_url('plugins/mailchimp-for-wp/mailchimp-for-wp.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'asia_garden_mailchimp_merge_styles' ) ) {
	
	function asia_garden_mailchimp_merge_styles($list) {
		$list[] = 'plugins/mailchimp-for-wp/mailchimp-for-wp.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (asia_garden_exists_mailchimp()) { require_once ASIA_GARDEN_THEME_DIR . 'plugins/mailchimp-for-wp/mailchimp-for-wp.styles.php'; }
?>