<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_essential_grid_theme_setup9')) {
	add_action( 'after_setup_theme', 'asia_garden_essential_grid_theme_setup9', 9 );
	function asia_garden_essential_grid_theme_setup9() {
		if (asia_garden_exists_essential_grid()) {
			add_action( 'wp_enqueue_scripts', 							'asia_garden_essential_grid_frontend_scripts', 1100 );
			add_filter( 'asia_garden_filter_merge_styles',					'asia_garden_essential_grid_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'asia_garden_filter_tgmpa_required_plugins',		'asia_garden_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_essential_grid_tgmpa_required_plugins' ) ) {
	
	function asia_garden_essential_grid_tgmpa_required_plugins($list=array()) {
		if (asia_garden_storage_isset('required_plugins', 'essential-grid')) {
			$path = asia_garden_get_file_dir('plugins/essential-grid/essential-grid.zip');
			$list[] = array(
						'name' 		=> asia_garden_storage_get_array('required_plugins', 'essential-grid'),
						'slug' 		=> 'essential-grid',
                        'version'	=> '3.0.15',
						'source'	=> !empty($path) ? $path : 'upload://essential-grid.zip',
						'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'asia_garden_exists_essential_grid' ) ) {
	function asia_garden_exists_essential_grid() {
        return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'asia_garden_essential_grid_frontend_scripts' ) ) {
	
	function asia_garden_essential_grid_frontend_scripts() {
		if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/essential-grid/essential-grid.css')!='')
			wp_enqueue_style( 'asia-garden-essential-grid',  asia_garden_get_file_url('plugins/essential-grid/essential-grid.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'asia_garden_essential_grid_merge_styles' ) ) {
	
	function asia_garden_essential_grid_merge_styles($list) {
		$list[] = 'plugins/essential-grid/essential-grid.css';
		return $list;
	}
}
?>