<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_cf7_theme_setup9')) {
	add_action( 'after_setup_theme', 'asia_garden_cf7_theme_setup9', 9 );
	function asia_garden_cf7_theme_setup9() {
		
		if (asia_garden_exists_cf7()) {
			add_action( 'wp_enqueue_scripts', 								'asia_garden_cf7_frontend_scripts', 1100 );
			add_filter( 'asia_garden_filter_merge_styles',						'asia_garden_cf7_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'asia_garden_filter_tgmpa_required_plugins',			'asia_garden_cf7_tgmpa_required_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_cf7_tgmpa_required_plugins' ) ) {

    function asia_garden_cf7_tgmpa_required_plugins($list=array()) {
        if (asia_garden_storage_isset('required_plugins', 'contact-form-7')) {
            $list[] = array(
                'name' 		=> asia_garden_storage_get_array('required_plugins', 'contact-form-7'),
                'slug' 		=> 'contact-form-7',
                'required' 	=> false
            );
        }
        return $list;
    }
}



// Check if cf7 installed and activated
if ( !function_exists( 'asia_garden_exists_cf7' ) ) {
	function asia_garden_exists_cf7() {
		return class_exists('WPCF7');
	}
}

// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'asia_garden_cf7_frontend_scripts' ) ) {

    function asia_garden_cf7_frontend_scripts() {
        if (asia_garden_exists_mailchimp()) {
            if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/contact-form-7/contact-form-7.css')!='')
                wp_enqueue_style( 'asia-garden-contact-form-7',  asia_garden_get_file_url('plugins/contact-form-7/contact-form-7.css'), array(), null );
        }
    }
}

// Merge custom styles
if ( !function_exists( 'asia_garden_cf7_merge_styles' ) ) {

    function asia_garden_cf7_merge_styles($list) {
        $list[] = 'plugins/contact-form-7/contact-form-7.css';
        return $list;
    }
}

?>