<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('asia_garden_booked_get_css')) {
	add_filter('asia_garden_filter_get_css', 'asia_garden_booked_get_css', 10, 4);
	function asia_garden_booked_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

.booked-calendar-wrap .booked-appt-list h2 {
	{$fonts['p_font-family']}
}
body table.booked-calendar thead th .monthName {
	{$fonts['h1_font-family']}
}

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Calendar */
table.booked-calendar th .monthName a {
	color: {$colors['text_dark']};
}
table.booked-calendar th .monthName a:hover {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text']};
}

/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}

#booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;
}

.booked-modal .bm-window p.booked-title-bar {
	background-color: {$colors['alter_dark']} !important;
}
.booked-modal .bm-window .close i {
	color: {$colors['inverse_text']};
}
.booked-modal .bm-window .close:hover i {
	color: {$colors['text_link']};
}

.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select,
#booked-profile-page .booked-tabs {
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a {
	background-color: {$colors['extra_bg_hover']};
	color: {$colors['extra_dark']};
}
table.booked-calendar thead,
table.booked-calendar thead th{
	color: {$colors['text_dark']} !important;
	background-color: {$colors['bg_color']} !important;
}
table.booked-calendar tr.days,
table.booked-calendar tr.days th,
#booked-profile-page .booked-tabs li.active a,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover {
	color: {$colors['inverse_text']} !important;
	background-color: {$colors['text_dark']} !important;
}
table.booked-calendar tr.days,
table.booked-calendar tr.days th {
	border-color: {$colors['extra_bd_color']} !important;
}
table.booked-calendar thead th i {
	color: {$colors['text_dark']} !important;
}
table.booked-calendar thead th a:hover i {
	color: {$colors['text_link']} !important;
}
table.booked-calendar td.today .date span {
	border-color: {$colors['text_link']};
}
table.booked-calendar td:hover .date span {
	color: {$colors['text_dark']} !important;
}
body table.booked-calendar tr.week td.active .date .number,
table.booked-calendar td.today .date span,
table.booked-calendar td.today:hover .date span,
table.booked-calendar td:hover .date span {
	background-color: {$colors['text_link']} !important;
	color: {$colors['inverse_link']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}
table.booked-calendar td,
table.booked-calendar td+td {
	border-color: {$colors['alter_bd_color']};
}

body table.booked-calendar td.prev-month .date {
    background: {$colors['bg_color']} !important;
}

body table.booked-calendar td.next-month .date span, 
body table.booked-calendar td.prev-month .date span {
	color: {$colors['extra_light']} !important;
}

body table.booked-calendar td.prev-date .date, 
body table.booked-calendar td.prev-date:hover .date, 
body table.booked-calendar td.prev-date:hover .date span {
    background: {$colors['bg_color']} !important;
	color: {$colors['extra_light']} !important;
}
body table.booked-calendar tr.week td.active .date, 
body table.booked-calendar tr.week td.active:hover .date, 
body table.booked-calendar tr.entryBlock,
body table.booked-calendar td:hover .date {
    background:  {$colors['bg_color']};
}

body table.booked-calendar td.next-month .date{
    background: {$colors['bg_color']} !important;
	color: {$colors['extra_light']} !important;
}
body table.booked-calendar td.next-month:hover .date span{
    background: {$colors['extra_light']} !important;
	color: {$colors['inverse_text']} !important;
}
.booked-calendar-wrap .booked-appt-list h2 strong {
	color: {$colors['text_dark']} !important;
}

body .booked-modal .bm-window p i.fa, 
body .booked-modal .bm-window a, 
body .booked-appt-list .booked-public-appointment-title, 
body .booked-modal .bm-window p.appointment-title, 
.booked-ms-modal.visible:hover .booked-book-appt {
	color: {$colors['text_dark']};
}
body .booked-modal .bm-window a:hover {
	color: {$colors['text_link']};
}

body .booked-form .field input.large, 
body .booked-form .field select.large {
	color: {$colors['input_text']};
	background-color: {$colors['input_bg_color']};
}

CSS;
		}

		return $css;
	}
}
?>