<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('asia_garden_booked_theme_setup9')) {
	add_action( 'after_setup_theme', 'asia_garden_booked_theme_setup9', 9 );
	function asia_garden_booked_theme_setup9() {
		if (asia_garden_exists_booked()) {
			add_action( 'wp_enqueue_scripts', 							'asia_garden_booked_frontend_scripts', 1100 );
			add_filter( 'asia_garden_filter_merge_styles',					'asia_garden_booked_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'asia_garden_filter_tgmpa_required_plugins',		'asia_garden_booked_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'asia_garden_booked_tgmpa_required_plugins' ) ) {
	
	function asia_garden_booked_tgmpa_required_plugins($list=array()) {
		if (asia_garden_storage_isset('required_plugins', 'booked')) {
			$path = asia_garden_get_file_dir('plugins/booked/booked.zip');
			$list[] = array(
					'name' 		=> asia_garden_storage_get_array('required_plugins', 'booked'),
					'slug' 		=> 'booked',
                    'version'	=> '2.3.5',
					'source' 	=> !empty($path) ? $path : 'upload://booked.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'asia_garden_exists_booked' ) ) {
	function asia_garden_exists_booked() {
		return class_exists('booked_plugin');
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'asia_garden_booked_frontend_scripts' ) ) {
	
	function asia_garden_booked_frontend_scripts() {
		if (asia_garden_is_on(asia_garden_get_theme_option('debug_mode')) && asia_garden_get_file_dir('plugins/booked/booked.css')!='')
			wp_enqueue_style( 'asia-garden-booked',  asia_garden_get_file_url('plugins/booked/booked.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'asia_garden_booked_merge_styles' ) ) {
	
	function asia_garden_booked_merge_styles($list) {
		$list[] = 'plugins/booked/booked.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (asia_garden_exists_booked()) { require_once ASIA_GARDEN_THEME_DIR . 'plugins/booked/booked.styles.php'; }
?>