<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

asia_garden_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'classie', asia_garden_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'asia-garden-gallery-script', asia_garden_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$asia_garden_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$asia_garden_sticky_out = asia_garden_get_theme_option('sticky_style')=='columns' 
							&& is_array($asia_garden_stickies) && count($asia_garden_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$asia_garden_cat = asia_garden_get_theme_option('parent_cat');
	$asia_garden_post_type = asia_garden_get_theme_option('post_type');
	$asia_garden_taxonomy = asia_garden_get_post_type_taxonomy($asia_garden_post_type);
	$asia_garden_show_filters = asia_garden_get_theme_option('show_filters');
	$asia_garden_tabs = array();
	if (!asia_garden_is_off($asia_garden_show_filters)) {
		$asia_garden_args = array(
			'type'			=> $asia_garden_post_type,
			'child_of'		=> $asia_garden_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $asia_garden_taxonomy,
			'pad_counts'	=> false
		);
		$asia_garden_portfolio_list = get_terms($asia_garden_args);
		if (is_array($asia_garden_portfolio_list) && count($asia_garden_portfolio_list) > 0) {
			$asia_garden_tabs[$asia_garden_cat] = esc_html__('All', 'asia-garden');
			foreach ($asia_garden_portfolio_list as $asia_garden_term) {
				if (isset($asia_garden_term->term_id)) $asia_garden_tabs[$asia_garden_term->term_id] = $asia_garden_term->name;
			}
		}
	}
	if (count($asia_garden_tabs) > 0) {
		$asia_garden_portfolio_filters_ajax = true;
		$asia_garden_portfolio_filters_active = $asia_garden_cat;
		$asia_garden_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters asia_garden_tabs asia_garden_tabs_ajax">
			<ul class="portfolio_titles asia_garden_tabs_titles">
				<?php
				foreach ($asia_garden_tabs as $asia_garden_id=>$asia_garden_title) {
					?><li><a href="<?php echo esc_url(asia_garden_get_hash_link(sprintf('#%s_%s_content', $asia_garden_portfolio_filters_id, $asia_garden_id))); ?>" data-tab="<?php echo esc_attr($asia_garden_id); ?>"><?php echo esc_html($asia_garden_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$asia_garden_ppp = asia_garden_get_theme_option('posts_per_page');
			if (asia_garden_is_inherit($asia_garden_ppp)) $asia_garden_ppp = '';
			foreach ($asia_garden_tabs as $asia_garden_id=>$asia_garden_title) {
				$asia_garden_portfolio_need_content = $asia_garden_id==$asia_garden_portfolio_filters_active || !$asia_garden_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $asia_garden_portfolio_filters_id, $asia_garden_id)); ?>"
					class="portfolio_content asia_garden_tabs_content"
					data-blog-template="<?php echo esc_attr(asia_garden_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(asia_garden_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($asia_garden_ppp); ?>"
					data-post-type="<?php echo esc_attr($asia_garden_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($asia_garden_taxonomy); ?>"
					data-cat="<?php echo esc_attr($asia_garden_id); ?>"
					data-parent-cat="<?php echo esc_attr($asia_garden_cat); ?>"
					data-need-content="<?php echo (false===$asia_garden_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($asia_garden_portfolio_need_content) 
						asia_garden_show_portfolio_posts(array(
							'cat' => $asia_garden_id,
							'parent_cat' => $asia_garden_cat,
							'taxonomy' => $asia_garden_taxonomy,
							'post_type' => $asia_garden_post_type,
							'page' => 1,
							'sticky' => $asia_garden_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		asia_garden_show_portfolio_posts(array(
			'cat' => $asia_garden_cat,
			'parent_cat' => $asia_garden_cat,
			'taxonomy' => $asia_garden_taxonomy,
			'post_type' => $asia_garden_post_type,
			'page' => 1,
			'sticky' => $asia_garden_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>