<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('asia_garden_storage_get')) {
	function asia_garden_storage_get($var_name, $default='') {
		global $ASIA_GARDEN_STORAGE;
		return isset($ASIA_GARDEN_STORAGE[$var_name]) ? $ASIA_GARDEN_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('asia_garden_storage_set')) {
	function asia_garden_storage_set($var_name, $value) {
		global $ASIA_GARDEN_STORAGE;
		$ASIA_GARDEN_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('asia_garden_storage_empty')) {
	function asia_garden_storage_empty($var_name, $key='', $key2='') {
		global $ASIA_GARDEN_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($ASIA_GARDEN_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($ASIA_GARDEN_STORAGE[$var_name][$key]);
		else
			return empty($ASIA_GARDEN_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('asia_garden_storage_isset')) {
	function asia_garden_storage_isset($var_name, $key='', $key2='') {
		global $ASIA_GARDEN_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($ASIA_GARDEN_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($ASIA_GARDEN_STORAGE[$var_name][$key]);
		else
			return isset($ASIA_GARDEN_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('asia_garden_storage_inc')) {
	function asia_garden_storage_inc($var_name, $value=1) {
		global $ASIA_GARDEN_STORAGE;
		if (empty($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = 0;
		$ASIA_GARDEN_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('asia_garden_storage_concat')) {
	function asia_garden_storage_concat($var_name, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (empty($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = '';
		$ASIA_GARDEN_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('asia_garden_storage_get_array')) {
	function asia_garden_storage_get_array($var_name, $key, $key2='', $default='') {
		global $ASIA_GARDEN_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($ASIA_GARDEN_STORAGE[$var_name][$key]) ? $ASIA_GARDEN_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($ASIA_GARDEN_STORAGE[$var_name][$key][$key2]) ? $ASIA_GARDEN_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('asia_garden_storage_set_array')) {
	function asia_garden_storage_set_array($var_name, $key, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if ($key==='')
			$ASIA_GARDEN_STORAGE[$var_name][] = $value;
		else
			$ASIA_GARDEN_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('asia_garden_storage_set_array2')) {
	function asia_garden_storage_set_array2($var_name, $key, $key2, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if (!isset($ASIA_GARDEN_STORAGE[$var_name][$key])) $ASIA_GARDEN_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$ASIA_GARDEN_STORAGE[$var_name][$key][] = $value;
		else
			$ASIA_GARDEN_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('asia_garden_storage_merge_array')) {
	function asia_garden_storage_merge_array($var_name, $key, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if ($key==='')
			$ASIA_GARDEN_STORAGE[$var_name] = array_merge($ASIA_GARDEN_STORAGE[$var_name], $value);
		else
			$ASIA_GARDEN_STORAGE[$var_name][$key] = array_merge($ASIA_GARDEN_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('asia_garden_storage_set_array_after')) {
	function asia_garden_storage_set_array_after($var_name, $after, $key, $value='') {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if (is_array($key))
			asia_garden_array_insert_after($ASIA_GARDEN_STORAGE[$var_name], $after, $key);
		else
			asia_garden_array_insert_after($ASIA_GARDEN_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('asia_garden_storage_set_array_before')) {
	function asia_garden_storage_set_array_before($var_name, $before, $key, $value='') {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if (is_array($key))
			asia_garden_array_insert_before($ASIA_GARDEN_STORAGE[$var_name], $before, $key);
		else
			asia_garden_array_insert_before($ASIA_GARDEN_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('asia_garden_storage_push_array')) {
	function asia_garden_storage_push_array($var_name, $key, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($ASIA_GARDEN_STORAGE[$var_name], $value);
		else {
			if (!isset($ASIA_GARDEN_STORAGE[$var_name][$key])) $ASIA_GARDEN_STORAGE[$var_name][$key] = array();
			array_push($ASIA_GARDEN_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('asia_garden_storage_pop_array')) {
	function asia_garden_storage_pop_array($var_name, $key='', $defa='') {
		global $ASIA_GARDEN_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($ASIA_GARDEN_STORAGE[$var_name]) && is_array($ASIA_GARDEN_STORAGE[$var_name]) && count($ASIA_GARDEN_STORAGE[$var_name]) > 0) 
				$rez = array_pop($ASIA_GARDEN_STORAGE[$var_name]);
		} else {
			if (isset($ASIA_GARDEN_STORAGE[$var_name][$key]) && is_array($ASIA_GARDEN_STORAGE[$var_name][$key]) && count($ASIA_GARDEN_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($ASIA_GARDEN_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('asia_garden_storage_inc_array')) {
	function asia_garden_storage_inc_array($var_name, $key, $value=1) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if (empty($ASIA_GARDEN_STORAGE[$var_name][$key])) $ASIA_GARDEN_STORAGE[$var_name][$key] = 0;
		$ASIA_GARDEN_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('asia_garden_storage_concat_array')) {
	function asia_garden_storage_concat_array($var_name, $key, $value) {
		global $ASIA_GARDEN_STORAGE;
		if (!isset($ASIA_GARDEN_STORAGE[$var_name])) $ASIA_GARDEN_STORAGE[$var_name] = array();
		if (empty($ASIA_GARDEN_STORAGE[$var_name][$key])) $ASIA_GARDEN_STORAGE[$var_name][$key] = '';
		$ASIA_GARDEN_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('asia_garden_storage_call_obj_method')) {
	function asia_garden_storage_call_obj_method($var_name, $method, $param=null) {
		global $ASIA_GARDEN_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($ASIA_GARDEN_STORAGE[$var_name]) ? $ASIA_GARDEN_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($ASIA_GARDEN_STORAGE[$var_name]) ? $ASIA_GARDEN_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('asia_garden_storage_get_obj_property')) {
	function asia_garden_storage_get_obj_property($var_name, $prop, $default='') {
		global $ASIA_GARDEN_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($ASIA_GARDEN_STORAGE[$var_name]->$prop) ? $ASIA_GARDEN_STORAGE[$var_name]->$prop : $default;
	}
}
?>