<?php
/**
 * The Header: Logo and main menu
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js scheme_<?php
										 // Class scheme_xxx need in the <html> as context for the <body>!
										 echo esc_attr(asia_garden_get_theme_option('color_scheme'));
										 ?>">
<head>
	<?php wp_head(); ?>
</head>

<body <?php	body_class(); ?>>
<?php wp_body_open(); ?>

	<?php do_action( 'asia_garden_action_before' ); ?>

	<div class="body_wrap">

		<div class="page_wrap"><?php

			// Desktop header
			$asia_garden_header_style = asia_garden_get_theme_option("header_style");
			if (strpos($asia_garden_header_style, 'header-custom-')===0) 
				$asia_garden_header_style = asia_garden_is_layouts_available() ? 'header-custom' : 'header-default';
			get_template_part( "templates/{$asia_garden_header_style}");

			// Side menu
			if (in_array(asia_garden_get_theme_option('menu_style'), array('left', 'right'))) {
				get_template_part( 'templates/header-navi-side' );
			}

			// Mobile header
			get_template_part( 'templates/header-mobile');
			?>

			<div class="page_content_wrap scheme_<?php echo esc_attr(asia_garden_get_theme_option('color_scheme')); ?>">

				<?php if (asia_garden_get_theme_option('body_style') != 'fullscreen') { ?>
				<div class="content_wrap">
				<?php } ?>

					<?php
					// Widgets area above page content
					asia_garden_create_widgets_area('widgets_above_page');
					?>				

					<div class="content">
						<?php
						// Widgets area inside page content
						asia_garden_create_widgets_area('widgets_above_content');
						?>				
