<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($asia_garden_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($asia_garden_post_format) ); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	asia_garden_show_post_featured(array(
		'thumb_size' => asia_garden_get_thumb_size($asia_garden_columns==1 ? 'big' : ($asia_garden_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(), 'sticky', $asia_garden_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>