<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_blog_style = explode('_', asia_garden_get_theme_option('blog_style'));
$asia_garden_columns = empty($asia_garden_blog_style[1]) ? 2 : max(2, $asia_garden_blog_style[1]);
$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($asia_garden_columns).' post_format_'.esc_attr($asia_garden_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$asia_garden_image_hover = asia_garden_get_theme_option('image_hover');
	// Featured image
	asia_garden_show_post_featured(array(
		'thumb_size' => asia_garden_get_thumb_size(strpos(asia_garden_get_theme_option('body_style'), 'full')!==false || $asia_garden_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $asia_garden_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $asia_garden_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>