<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_blog_style = explode('_', asia_garden_get_theme_option('blog_style'));
$asia_garden_columns = empty($asia_garden_blog_style[1]) ? 2 : max(2, $asia_garden_blog_style[1]);
$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');
$asia_garden_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($asia_garden_columns).' post_format_'.esc_attr($asia_garden_post_format) ); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($asia_garden_image[1]) && !empty($asia_garden_image[2])) echo intval($asia_garden_image[1]) .'x' . intval($asia_garden_image[2]); ?>"
	data-src="<?php if (!empty($asia_garden_image[0])) echo esc_url($asia_garden_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$asia_garden_image_hover = 'icon';	
	if (in_array($asia_garden_image_hover, array('icons', 'zoom'))) $asia_garden_image_hover = 'dots';
	$asia_garden_components = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('meta_parts'));
	$asia_garden_counters = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('counters')) 
								? 'comments'
								: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('counters'));
	asia_garden_show_post_featured(array(
		'hover' => $asia_garden_image_hover,
		'thumb_size' => asia_garden_get_thumb_size( strpos(asia_garden_get_theme_option('body_style'), 'full')!==false || $asia_garden_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($asia_garden_components)
										? asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(
											'components' => $asia_garden_components,
											'counters' => $asia_garden_counters,
											'seo' => false,
											'echo' => false
											), $asia_garden_blog_style[0], $asia_garden_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'asia-garden') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>