<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($asia_garden_post_format) ); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	asia_garden_show_post_featured(array( 'thumb_size' => asia_garden_get_thumb_size( strpos(asia_garden_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('asia_garden_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('asia_garden_action_before_post_meta'); 

			// Post meta
			$asia_garden_components = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('meta_parts')) 
										? 'categories,date,counters,edit'
										: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('meta_parts'));
			$asia_garden_counters = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('counters')) 
										? 'comments'
										: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('counters'));

			if (!empty($asia_garden_components))
				asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(
					'components' => $asia_garden_components,
					'counters' => $asia_garden_counters,
					'seo' => false
					), 'excerpt', 1)
				);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content  <?php if (has_excerpt()) echo 'no_content'; ?>"><?php
		if (asia_garden_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'asia-garden' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'asia-garden' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$asia_garden_show_learn_more = !in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($asia_garden_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($asia_garden_post_format == 'quote') {
					if (($quote = asia_garden_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						asia_garden_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $asia_garden_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'asia-garden'); ?></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>