<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_blog_style = explode('_', asia_garden_get_theme_option('blog_style'));
$asia_garden_columns = empty($asia_garden_blog_style[1]) ? 2 : max(2, $asia_garden_blog_style[1]);
$asia_garden_expanded = !asia_garden_sidebar_present() && asia_garden_is_on(asia_garden_get_theme_option('expand_content'));
$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');
$asia_garden_components = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('meta_parts')) 
							? 'categories,date,counters'.($asia_garden_columns < 3 ? ',edit' : '')
							: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('meta_parts'));
$asia_garden_counters = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('counters')) 
							? 'comments'
							: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('counters'));

?><div class="<?php asia_garden_show_layout($asia_garden_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($asia_garden_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($asia_garden_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($asia_garden_columns)
					. ' post_layout_'.esc_attr($asia_garden_blog_style[0]) 
					. ' post_layout_'.esc_attr($asia_garden_blog_style[0]).'_'.esc_attr($asia_garden_columns)
					); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	asia_garden_show_post_featured( array( 'thumb_size' => asia_garden_get_thumb_size($asia_garden_blog_style[0] == 'classic'
													? (strpos(asia_garden_get_theme_option('body_style'), 'full')!==false 
															? ( $asia_garden_columns > 2 ? 'big' : 'huge' )
															: (	$asia_garden_columns > 2
																? ($asia_garden_expanded ? 'med' : 'small')
																: ($asia_garden_expanded ? 'big' : 'med')
																)
														)
													: (strpos(asia_garden_get_theme_option('body_style'), 'full')!==false 
															? ( $asia_garden_columns > 2 ? 'masonry-big' : 'full' )
															: (	$asia_garden_columns <= 2 && $asia_garden_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('asia_garden_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('asia_garden_action_before_post_meta'); 

			// Post meta
			if (!empty($asia_garden_components))
				asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(
					'components' => $asia_garden_components,
					'counters' => $asia_garden_counters,
					'seo' => false
					), $asia_garden_blog_style[0], $asia_garden_columns)
				);

			do_action('asia_garden_action_after_post_meta'); 
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$asia_garden_show_learn_more = false; 
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($asia_garden_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($asia_garden_post_format == 'quote') {
				if (($quote = asia_garden_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					asia_garden_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($asia_garden_components))
				asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(
					'components' => $asia_garden_components,
					'counters' => $asia_garden_counters
					), $asia_garden_blog_style[0], $asia_garden_columns)
				);
		}
		// More button
		if ( $asia_garden_show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'asia-garden'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>