<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

$asia_garden_blog_style = explode('_', asia_garden_get_theme_option('blog_style'));
$asia_garden_columns = empty($asia_garden_blog_style[1]) ? 1 : max(1, $asia_garden_blog_style[1]);
$asia_garden_expanded = !asia_garden_sidebar_present() && asia_garden_is_on(asia_garden_get_theme_option('expand_content'));
$asia_garden_post_format = get_post_format();
$asia_garden_post_format = empty($asia_garden_post_format) ? 'standard' : str_replace('post-format-', '', $asia_garden_post_format);
$asia_garden_animation = asia_garden_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($asia_garden_columns).' post_format_'.esc_attr($asia_garden_post_format) ); ?>
	<?php echo (!asia_garden_is_off($asia_garden_animation) ? ' data-animation="'.esc_attr(asia_garden_get_animation_classes($asia_garden_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($asia_garden_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.esc_attr(the_title_attribute( array( 'echo' => false ) )).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	asia_garden_show_post_featured( array(
											'class' => $asia_garden_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => asia_garden_get_thumb_size(
																	strpos(asia_garden_get_theme_option('body_style'), 'full')!==false
																		? ( $asia_garden_columns > 1 ? 'huge' : 'huge' )
																		: (	$asia_garden_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('asia_garden_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('asia_garden_action_before_post_meta'); 

			// Post meta
			$asia_garden_components = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('meta_parts')) 
										? 'categories,date'.($asia_garden_columns < 3 ? ',counters' : '').($asia_garden_columns == 1 ? ',edit' : '')
										: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('meta_parts'));
			$asia_garden_counters = asia_garden_is_inherit(asia_garden_get_theme_option_from_meta('counters')) 
										? 'comments'
										: asia_garden_array_get_keys_by_value(asia_garden_get_theme_option('counters'));
			$asia_garden_post_meta = empty($asia_garden_components) 
										? '' 
										: asia_garden_show_post_meta(apply_filters('asia_garden_filter_post_meta_args', array(
												'components' => $asia_garden_components,
												'counters' => $asia_garden_counters,
												'seo' => false,
												'echo' => false
												), $asia_garden_blog_style[0], $asia_garden_columns)
											);
			asia_garden_show_layout($asia_garden_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$asia_garden_show_learn_more = !in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($asia_garden_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($asia_garden_post_format == 'quote') {
					if (($quote = asia_garden_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						asia_garden_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($asia_garden_post_format, array('link', 'aside', 'status', 'quote'))) {
				asia_garden_show_layout($asia_garden_post_meta);
			}
			// More button
			if ( $asia_garden_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'asia-garden'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>