<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage ASIA_GARDEN
 * @since ASIA_GARDEN 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$asia_garden_content = '';
$asia_garden_blog_archive_mask = '%%CONTENT%%';
$asia_garden_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $asia_garden_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($asia_garden_content = apply_filters('the_content', get_the_content())) != '') {
		if (($asia_garden_pos = strpos($asia_garden_content, $asia_garden_blog_archive_mask)) !== false) {
			$asia_garden_content = preg_replace('/(\<p\>\s*)?'.$asia_garden_blog_archive_mask.'(\s*\<\/p\>)/i', $asia_garden_blog_archive_subst, $asia_garden_content);
		} else
			$asia_garden_content .= $asia_garden_blog_archive_subst;
		$asia_garden_content = explode($asia_garden_blog_archive_mask, $asia_garden_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) asia_garden_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$asia_garden_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$asia_garden_args = asia_garden_query_add_posts_and_cats($asia_garden_args, '', asia_garden_get_theme_option('post_type'), asia_garden_get_theme_option('parent_cat'));
$asia_garden_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($asia_garden_page_number > 1) {
	$asia_garden_args['paged'] = $asia_garden_page_number;
	$asia_garden_args['ignore_sticky_posts'] = true;
}
$asia_garden_ppp = asia_garden_get_theme_option('posts_per_page');
if ((int) $asia_garden_ppp != 0)
	$asia_garden_args['posts_per_page'] = (int) $asia_garden_ppp;
// Make a new query
query_posts( $asia_garden_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($asia_garden_content) && count($asia_garden_content) == 2) {
	set_query_var('blog_archive_start', $asia_garden_content[0]);
	set_query_var('blog_archive_end', $asia_garden_content[1]);
}

get_template_part('index');
?>