<?php
/**
 * The main template file for display page.
 *
 * @package WordPress
*/

/**
*	Get current page id
**/
$current_page_id = get_option( 'woocommerce_shop_page_id' );

get_header();

//Get Shop Sidebar
$page_sidebar = '';

//Get Shop Sidebar Display Settting
$artale_shop_layout = get_theme_mod('artale_shop_layout', 'fullwidth');

if(ARTALE_THEMEDEMO && isset($_GET['sidebar']))
{
	$artale_shop_layout = 'sidebar';
}

if($artale_shop_layout == 'sidebar')
{
	$page_sidebar = 'Shop Sidebar';
}

//Check if woocommerce page
$shop_page_id = get_option( 'woocommerce_shop_page_id' );

//Get Page Menu Transparent Option
$page_menu_transparent = get_post_meta($shop_page_id, 'page_menu_transparent', true);

$page_show_title = get_post_meta($shop_page_id, 'page_show_title', true);

//If single product page then hide page header
if(is_product())
{
	$page_show_title = 0;
	$page_menu_transparent = 0;
}

if(empty($page_show_title))
{
	$query_term = get_query_var('term');
	
	if(is_archive() && !empty($query_term))
	{
		$ob_term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
	    $page_taxonomy = get_taxonomy($ob_term->taxonomy);
	    $page_title = $ob_term->name;
	}
	else
	{
		$page_title = get_the_title($shop_page_id);
	}
	
	//Get current page tagline
	$page_tagline = get_post_meta($current_page_id, 'page_tagline', true);

	$pp_page_bg = '';
	
	//Get page featured image
	if(has_post_thumbnail($current_page_id, 'full'))
    {
        $image_id = get_post_thumbnail_id($current_page_id); 
        $image_thumb = wp_get_attachment_image_src($image_id, 'full', true);
        
        if(isset($image_thumb[0]) && !empty($image_thumb[0]))
        {
        	$pp_page_bg = $image_thumb[0];
        }
    }
    
    if(is_product())
    {
	    $page_title = get_the_title($shop_page_id);
	    $page_tagline = '<a href="'.esc_url(get_permalink($shop_page_id)).'"><span class="ti-arrow-left"></span>&nbsp;'.esc_html__('Back to shop', 'artale' ).'</a>';
	    
	    //Remove sidebar from single product page
	    $page_sidebar = '';
    }
    else
    {
	    $cart_page_id = get_option( 'woocommerce_cart_page_id' );
    }
    
    $artale_topbar = artale_get_topbar();
?>
<div id="page-header" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php } ?> <?php if(!empty($artale_topbar)) { ?>withtopbar<?php } ?> <?php if(!empty($artale_screen_class)) { echo esc_attr($artale_screen_class); } ?> <?php if(!empty($artale_page_content_class)) { echo esc_attr($artale_page_content_class); } ?>" <?php if(!empty($pp_page_bg)) { ?>style="background-image:url(<?php echo esc_url($pp_page_bg); ?>);"<?php } ?>>
	
	<?php 
		if(!empty($pp_page_bg)) 
		{
	?>
		<div id="page-header-overlay"></div>
	<?php
		}
	?>

	<?php
		if(empty($page_show_title))
		{
	?>
	<div class="page-title-wrapper">
		<div class="standard-wrapper">
			<div class="page-title-inner">
				<div class="page-title-content">
					<h1 <?php if(!empty($pp_page_bg) && !empty($artale_topbar)) { ?>class ="withtopbar"<?php } ?>><?php echo esc_html($page_title); ?></h1>
					<?php
				    	if(!empty($page_tagline))
				    	{
				    ?>
				    	<div class="page-tagline">
				    		<?php echo nl2br($page_tagline); ?>
				    	</div>
				    <?php
				    	}
				    ?>
				    <?php
					    //Check if display categories filter
					    $artale_shop_cat_filter = get_theme_mod('artale_shop_layout', 1);
					    
					    if(!empty($artale_shop_cat_filter))
					    {
							//Get all Woocommerce product categories
							$taxonomy     = 'product_cat';
							$orderby      = 'name';  
							$show_count   = 0;      
							$pad_counts   = 0;      
							$hierarchical = 1;  
							$title        = '';  
							$empty        = 0;
							
							$args = array(
							       'taxonomy'     => $taxonomy,
							       'orderby'      => $orderby,
							       'show_count'   => $show_count,
							       'pad_counts'   => $pad_counts,
							       'hierarchical' => $hierarchical,
							       'title_li'     => $title,
							       'hide_empty'   => $empty
							);
							$all_categories = get_categories( $args );
							
							if(!empty($all_categories) && is_array($all_categories)) {
								
								//Get shop page URL
								$shop_page_id = get_option('woocommerce_shop_page_id');
								$shop_page_url = get_permalink($shop_page_id);
					?>
						<ul class="page-shop-categories-filter">
							<li><a <?php if(empty($query_term)) {?>class="active"<?php } ?> href="<?php echo esc_url($shop_page_url); ?>"><?php esc_html_e('All Products', 'artale' ); ?></a></li>
					<?php
						}
						
							foreach ($all_categories as $cat) {    
					?>
							<li><a <?php if(isset($ob_term) && $ob_term->term_id == $cat->term_id) {?>class="active"<?php } ?> href="<?php echo esc_url(get_term_link($cat->slug, 'product_cat')); ?>"><?php echo esc_html($cat->name); ?></a></li>
					<?php
							}
						
							if(!empty($all_categories) && is_array($all_categories)) { 
					?>
						</ul>
					<?php
							}
						}
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
		}
	?>
</div>
<?php
	}
?>

<!-- Begin content -->
<div id="page-content-wrapper" class="<?php if(!empty($pp_page_bg)) { ?>hasbg<?php } ?> <?php if(!empty($page_show_title)) { ?>no-title<?php } ?>">
    <div class="inner ">
    	<!-- Begin main content -->
    	<div class="inner-wrapper">
    		<div class="sidebar-content <?php if(empty($page_sidebar)) { ?>fullwidth<?php } ?>">
				
				<?php woocommerce_content();  ?>
				
    		</div>
    		<?php if(!empty($page_sidebar)) { ?>
    		<div class="sidebar-wrapper">
	            <div class="sidebar">
	            
	            	<div class="content">
	            
	            		<?php 
						$page_sidebar = sanitize_title($page_sidebar);
						
						if (is_active_sidebar($page_sidebar)) { ?>
		    	    		<ul class="sidebar-widget">
		    	    		<?php dynamic_sidebar($page_sidebar); ?>
		    	    		</ul>
		    	    	<?php } ?>
	            	
	            	</div>
	        
	            </div>
            <br class="clear"/>
        
            <div class="sidebar_bottom"></div>
			</div>
    		<?php } ?>
    	</div>
    	<!-- End main content -->
    </div>
</div>
<!-- End content -->

<?php get_footer(); ?>