<?php
/**
*	Get Current page object
**/
$page = get_page($post->ID);

/**
*	Get current page id
**/

if(!isset($current_page_id) && isset($page->ID))
{
    $current_page_id = $page->ID;
}

$artale_topbar = artale_get_topbar();
$artale_screen_class = artale_get_screen_class();
$artale_page_content_class = artale_get_page_content_class();

$pp_page_bg = '';

//Check if display blog featured content
$artale_blog_feat_content = get_theme_mod('artale_blog_feat_content', false);

//Check if hide post featured
$hide_featured_image = get_post_meta($post->ID, 'hide_featured_image', true);
if(!empty($hide_featured_image))
{
	$artale_blog_feat_content = 0;
}

//Get page featured image
if(has_post_thumbnail($current_page_id, 'original') && !empty($artale_blog_feat_content))
{
    $image_id = get_post_thumbnail_id($current_page_id); 
    $image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
    
    if(isset($image_thumb[0]) && !empty($image_thumb[0]))
    {
    	$pp_page_bg = $image_thumb[0];
    }
}
?>

<div id="page-header" class="<?php if(!empty($pp_page_bg)) { ?>has-featured<?php } ?><?php if(!empty($artale_topbar)) { ?>withtopbar<?php } ?> <?php if(!empty($artale_screen_class)) { echo esc_attr($artale_screen_class); } ?> <?php if(!empty($artale_page_content_class)) { echo esc_attr($artale_page_content_class); } ?>">
	<div class="page-title-wrapper">
		<div class="standard-wrapper">
			<div class="page-title-inner">
				<?php
					$artale_page_title_font_alignment = get_theme_mod('artale_blog_title_font_alignment', 'center');	
				?>
				<div class="page-title-content title_align_<?php echo esc_attr($artale_page_title_font_alignment); ?>">
					<h1 <?php if(!empty($pp_page_bg) && !empty($artale_topbar)) { ?>class="withtopbar"<?php } ?>><span><?php the_title(); ?></span></h1>
					
					<?php
						//Get blog categories
						$artale_blog_cat = get_theme_mod('artale_blog_cat', true);
						if(!empty($artale_blog_cat))
						{
					?>
					<div class="post-detail single-post">
						<?php
							//Get blog date
							$artale_blog_date = get_theme_mod('artale_blog_date', true);
							if(!empty($artale_blog_date))
							{
						?>
					    <div class="post-info-date" ><?php echo date_i18n(ARTALE_THEMEDATEFORMAT, get_the_time('U')); ?></div>
						<?php
						    }
						?>
						
				    	<span class="post-info-cat">
							<?php
							   //Get Post's Categories
							   $post_categories = wp_get_post_categories($post->ID);
							   
							   $count_categories = count($post_categories);
							   $i = 0;
							   
							   if(!empty($post_categories))
							   {
							      	foreach($post_categories as $key => $c)
							      	{
							      		$cat = get_category( $c );
							?>
							      	<a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
							<?php
								   		if(++$i != $count_categories) 
								   		{
								   			echo '&nbsp;&middot;&nbsp;';
								   		}
							      	}
							   }
							?>
				    	</span>
				 	</div>
				 	<?php
					 	}
					?>
						
					<?php
					    $artale_blog_display_author = get_theme_mod('artale_blog_display_author', true);
					    
					    if($artale_blog_display_author)
					    {
					?>
					<div class="post-author">
					    <div class="gravatar"><?php echo get_avatar( get_the_author_meta('email', $post->post_author), 200 ); ?></div>
					    <div class="post-author-detail">
					     	<span class="post-author-name-before"><span class="post-author-name"><h6><?php echo get_the_author_meta('display_name', $post->post_author); ?></h6></span></span>
					    </div>
					</div>
					<?php
					    }
					?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php 
	if(!empty($pp_page_bg)) { 
	
	//Check if add parallax effect
	$artale_blog_feat_content_parallax = get_theme_mod('artale_blog_feat_content_parallax', true);
?>
	<div id="post-featured-header" <?php if($artale_blog_feat_content_parallax) { ?>class="themegoods-parallax"<?php } ?>" style="background-image:url(<?php echo esc_url($pp_page_bg); ?>);"></div>
<?php } ?>

<!-- Begin content -->
<div id="page-content-wrapper" class="blog-wrapper <?php if(!empty($pp_page_bg)) { ?>hasbg <?php } ?><?php if(!empty($pp_page_bg) && !empty($artale_topbar)) { ?>withtopbar <?php } ?><?php if(!empty($artale_page_content_class)) { echo esc_attr($artale_page_content_class); } ?>">
<?php
	//Check if custom post type plugin is installed	
	$artale_custom_post = ABSPATH . '/wp-content/plugins/artale-custom-post/artale-custom-post.php';
	
	$artale_custom_post_activated = file_exists($artale_custom_post);
	
	if($artale_custom_post_activated)
	{
		include_once( ABSPATH . '/wp-content/plugins/artale-custom-post/templates/template-share.php');
	}
?>