<?php
/**
 * The main template file for display single post page.
 *
 * @package WordPress
*/

/**
*	Get current page id
**/

$current_page_id = $post->ID;

if($post->post_type == 'galleries')
{
	//Check if using Elementor to edit gallery page or not
	if ( function_exists('elementor_load_plugin_textdomain') && Elementor\Plugin::instance()->db->is_built_with_elementor($current_page_id) ) {
		get_template_part("page");
	}
	else
	{
		get_template_part("single-post-f");
	}
	
	exit;
}
else if($post->post_type == 'portfolios')
{
	//Get custom link
	$portfolio_link = get_post_meta($current_page_id, 'portfolio_link', true);
	if(!empty($portfolio_link))
	{
		header('Location: '.$portfolio_link);
	}
	
	//Check if using Elementor to edit gallery page or not
	if ( function_exists('elementor_load_plugin_textdomain') && Elementor\Plugin::instance()->db->is_built_with_elementor($current_page_id) ) {
		get_template_part("page");
	}
	else
	{
		get_template_part("single-post-f");
	}
	
	exit;
}
else if($post->post_type == 'lp_course')
{
	get_template_part("page");
	exit;
}
elseif($post->post_type == 'elementor_library')
{
	get_template_part("page-canvas");

	exit;
}
else if(isset($_GET['elementor_library']) && !empty($_GET['elementor_library']))
{
	get_template_part("page");
	exit;
}
else
{
	$post_layout = get_post_meta($post->ID, 'post_layout', true);
	
	switch($post_layout)
	{
		case 'With Right Sidebar':
		default:
			get_template_part("single-post-r");
			exit;
		break;
		
		case 'With Left Sidebar':
			get_template_part("single-post-l");
			exit;
		break;
		
		case 'Fullwidth':
			get_template_part("single-post-f");
			exit;
		break;
	}
}
?>