<?php
/**
 * The main template file for display single post page.
 *
 * @package WordPress
*/

get_header(); 

$artale_topbar = artale_get_topbar();

/**
*	Get current page id
**/

$current_page_id = $post->ID;

//Include custom header feature, if no password protected
$inner_background_image_style = '';

if(!post_password_required()){
	get_template_part("/templates/template-post-header");
}
else
{
	//Get page featured image
	if(has_post_thumbnail($current_page_id, 'original'))
	{
		$image_id = get_post_thumbnail_id($current_page_id); 
		$image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
		
		if(isset($image_thumb[0]) && !empty($image_thumb[0]))
		{
			$pp_page_bg = $image_thumb[0];
			$inner_background_image_style = 'style="background-image:url(\''.esc_url($pp_page_bg).'\');"';
		}
	}
}
?>
    
    <div class="inner" <?php echo $inner_background_image_style; ?>>

    	<!-- Begin main content -->
    	<div class="inner-wrapper">

    		<div class="sidebar-content left-sidebar <?php if(!is_active_sidebar('single-post-sidebar')) { ?>fullwidth blog_f<?php } ?>">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();

	$image_thumb = '';
								
	if(!empty($artale_blog_feat_content) && has_post_thumbnail(get_the_ID(), 'large'))
	{
	    $image_id = get_post_thumbnail_id(get_the_ID());
	    $image_thumb = wp_get_attachment_image_src($image_id, 'large', true);
	}
?>
						
<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post-wrapper">
		
		<?php
		    //Get video embed code
		    $post_video_embed = get_post_meta($post->ID, 'post_video_embed', true);
		    if(!empty($post_video_embed))
		    {
		?>
				<div class="video-wrapper"><?php echo trim($post_video_embed); ?></div>
		<?php
		    }
		    
		    the_content();
		?>
		<br class="clear"/>
		<?php
		    wp_link_pages();

			//Get share button
			get_template_part("/templates/template-post-tags");
		?>
	    
	</div>
	
	<?php
		//Get post author
		get_template_part("/templates/template-author");
				
	    //Get post related
		get_template_part("/templates/template-post-related");
	?>

</div>
<!-- End each blog post -->

<?php
if (comments_open($post->ID) OR artale_post_has('pings', $post->ID)) 
{
?>
<div class="fullwidth-comment-wrapper sidebar theme-border"><?php comments_template( '', true ); ?></div>
<?php
}
?>

<?php
//Get post navigation, if no password protected
if(!post_password_required()){
	get_template_part("/templates/template-post-navigation");
}
?>

<?php endwhile; endif; ?>
						
    	</div>

    		<?php 
				if (is_active_sidebar('single-post-sidebar')) 
				{ 
			?>	
    			<div class="sidebar-wrapper left-sidebar">
    		
	    			<div class="sidebar_top"></div>
	    		
	    			<div class="sidebar">
	    			
	    				<div class="content">
	
			    	    	<ul class="sidebar-widget">
			    	    		<?php dynamic_sidebar('single-post-sidebar'); ?>
			    	    	</ul>
	    				
	    				</div>
	    		
	    			</div>
	    			<br class="clear"/>
	    	
	    			<div class="sidebar_bottom"></div>
    			</div>
    		<?php 
	    		}
	    	?>
    
    </div>
    <!-- End main content -->
   
</div>

<br class="clear"/><br/>
</div>
<?php get_footer(); ?>