<?php
/**
 * The main template file for display single post page.
 *
 * @package WordPress
*/

get_header(); 

$artale_topbar = artale_get_topbar();

/**
*	Get current page id
**/

$current_page_id = $post->ID;

$inner_background_image_style = "";

//Include custom header feature, if no password protected
$inner_background_image_style = '';

if(!post_password_required()){
	get_template_part("/templates/template-post-header");
}
else
{
	//Get page featured image
	if(has_post_thumbnail($current_page_id, 'original'))
	{
		$image_id = get_post_thumbnail_id($current_page_id); 
		$image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
		
		if(isset($image_thumb[0]) && !empty($image_thumb[0]))
		{
			$pp_page_bg = $image_thumb[0];
			$inner_background_image_style = 'style="background-image:url(\''.esc_url($pp_page_bg).'\');"';
		}
	}
}
?>
    
    <div class="inner" <?php echo $inner_background_image_style; ?>>

    	<!-- Begin main content -->
    	<div class="inner-wrapper">

    		<div class="sidebar-content fullwidth blog_f">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();
?>
						
<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post-wrapper">

	    <?php
		    //Get video embed code
		    $post_video_embed = get_post_meta($post->ID, 'post_video_embed', true);
		    if(!empty($post_video_embed))
		    {
		?>
				<div class="video-wrapper"><?php echo trim($post_video_embed); ?></div>
		<?php
		    }
		    
		    the_content();
		?>
		
		<?php
			//If default single gallery page
			if($post->post_type == 'galleries' && !post_password_required()) {
				$images = artale_get_gallery_images($post->ID, 'drag');
				
				foreach($images as $image_id)
				{
					$original_image_url = wp_get_attachment_image_src($image_id, 'original', true);
					
					//Get image meta data
					$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					$image_title = get_the_title($image_id);
		?>
					<img src="<?php echo esc_url($original_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" />
		<?php
					if(!empty($image_title)) {
		?>
					<p class="wp-caption-text"><?php echo esc_html($image_title); ?></p><br/>
		<?php
					}
				}
			}
		?>
		
		<br class="clear"/>
		<?php
		    wp_link_pages();

			//Get share button
			get_template_part("/templates/template-post-tags");
		?>
	    
	</div>
	
	<?php
		//Get post author
		get_template_part("/templates/template-author");
				
	    //Get post related
		get_template_part("/templates/template-post-related");
	?>

</div>
<!-- End each blog post -->

<?php
if(comments_open($post->ID) OR artale_post_has('pings', $post->ID)) 
{
?>
<div class="fullwidth-comment-wrapper sidebar theme-border"><?php comments_template( '', true ); ?></div>
<?php
}
?>

<?php
//Get post navigation, if no password protected
if(!post_password_required()){
	get_template_part("/templates/template-post-navigation");
}
?>

<?php endwhile; endif; ?>
						
    	</div>
    
    </div>
    <!-- End main content -->
</div>

<br class="clear"/>
</div>
<?php get_footer(); ?>