<?php
/**
 * The main template file for display blog page.
 *
 * @package WordPress
*/

get_header(); 

//Include custom header feature
get_template_part("/templates/template-header");
?>

<?php
$page_sidebar = 'Search Sidebar';
?>

<!-- Begin content -->
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner-wrapper">
			
			<?php
			if(have_posts())
			{
			?>
			<div class="search-form-wrapper">
				<form class="searchform" method="get" action="<?php echo esc_url(home_url('/')); ?>">
					<p class="input-wrapper">
						<input type="text" class="input-effect field searchform-s" name="s" value="<?php the_search_query(); ?>" placeholder="<?php esc_attr_e('Type to search...', 'artale' ); ?>">
						<!-- input type="submit" value="<?php esc_attr_e('Search', 'artale' ); ?>"/ -->
					</p>
				</form>
			</div>
			<?php
			}	
			?>

    			<div class="sidebar-content <?php if(!have_posts() OR !is_active_sidebar('search-sidebar')) { ?>fullwidth<?php } ?>">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();
?>

<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post-wrapper">
	    
	    <div class="post-content-wrapper">
			<div class="post-header-wrapper">
				<div class="post-header">
			    	<div class="post-header_title">
				    	<h5><a href="<?php echo esc_url(get_permalink()); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h5>
			    	</div>
			    </div>
				
				<?php
				 //Get blog categories
				 $artale_blog_cat = get_theme_mod('artale_blog_cat', true);
				 if(!empty($artale_blog_cat))
				 {
			 ?>
			 <div class="post-detail single-post">
				<?php
					//Get blog date
					$artale_blog_date = get_theme_mod('artale_blog_date', true);
					if(!empty($artale_blog_date))
					{
				?>
				<div class="post-info-date"><?php echo date_i18n(ARTALE_THEMEDATEFORMAT, get_the_time('U')); ?></div>
				<?php
					}
				?>
				 
				 <span class="post-info-cat">
					 <?php
						//Get Post's Categories
						$post_categories = wp_get_post_categories($post->ID);
						
						$count_categories = count($post_categories);
						$i = 0;
						
						if(!empty($post_categories))
						{
							   foreach($post_categories as $key => $c)
							   {
								   $cat = get_category( $c );
					 ?>
							   <a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
					 <?php
									if(++$i != $count_categories) 
									{
										echo '&nbsp;&middot;&nbsp;';
									}
							   }
						}
					 ?>
				 </span>
			 </div>
			 <?php
				  }
			?>
			    
			    <?php
			    	$artale_blog_display_full = get_theme_mod('artale_blog_display_full', false);
			    	
			    	if(!empty($artale_blog_display_full))
			    	{
			    		the_content();
			    	}
			    	else
			    	{
			    		the_excerpt();
			    	}
			    ?>
			</div>
	    </div>
	    
	</div>

</div>
<!-- End each blog post -->

<?php endwhile; endif; ?>

		<?php
			//Hide page title if doesn't have any results
			if(!have_posts())
			{
		?>
			<h1><?php esc_html_e('Nothing Found', 'artale' ); ?></h1>
    	
	    	<div class="search-form-wrapper">
		    	<?php esc_html_e( "Sorry, but nothing matched your search terms. Please try again with some different keywords.", 'artale' ); ?>
		    	<br/><br/>
		    	
	    		<form class="searchform" method="get" action="<?php echo esc_url(home_url('/')); ?>">
		    		<p class="input-wrapper">
			    		<input type="text" class="input-effect field searchform-s" name="s" value="<?php the_search_query(); ?>" placeholder="<?php esc_attr_e('Type to search...', 'artale' ); ?>">
						<!-- input type="submit" value="<?php esc_attr_e('Search', 'artale' ); ?>"/ -->
		    		</p>
			    </form>
    		</div>
		<?php
			}	
		?>

    	<?php
		    if($wp_query->max_num_pages > 1)
		    {
		    	if (function_exists("artale_pagination")) 
		    	{
		    	    artale_pagination($wp_query->max_num_pages);
		    	}
		    	else
		    	{
		    	?>
		    	    <div class="pagination"><p><?php posts_nav_link(' '); ?></p></div>
		    	<?php
		    	}
		    ?>
		    <div class="pagination-detail">
		     	<?php
		     		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		     	?>
		     	<?php esc_html_e('Page', 'artale' ); ?> <?php echo esc_html($paged); ?> <?php esc_html_e('of', 'artale' ); ?> <?php echo esc_html($wp_query->max_num_pages); ?>
		     </div>
		     <?php
		     }
		?>
    	</div>
    	
    		<div class="sidebar-wrapper">
    		
    			<div class="sidebar_top"></div>
    		
    			<div class="sidebar">
    			
    				<div class="content">
    			
    					<ul class="sidebar-widget">
    					<?php dynamic_sidebar($page_sidebar); ?>
    					</ul>
    				
    				</div>
    		
    			</div>
    			<br class="clear"/>
    	
    			<div class="sidebar_bottom"></div>
    		</div>
    	</div>
    	
    </div>
    <!-- End main content -->
    </div>
	
</div>
</div>
<?php get_footer(); ?>